/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_CursorFrameInfo;
import org.lwjgl.sdl.SDL_MouseMotionTransformCallbackI;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLMouse {
    public static final int SDL_SYSTEM_CURSOR_DEFAULT = 0;
    public static final int SDL_SYSTEM_CURSOR_TEXT = 1;
    public static final int SDL_SYSTEM_CURSOR_WAIT = 2;
    public static final int SDL_SYSTEM_CURSOR_CROSSHAIR = 3;
    public static final int SDL_SYSTEM_CURSOR_PROGRESS = 4;
    public static final int SDL_SYSTEM_CURSOR_NWSE_RESIZE = 5;
    public static final int SDL_SYSTEM_CURSOR_NESW_RESIZE = 6;
    public static final int SDL_SYSTEM_CURSOR_EW_RESIZE = 7;
    public static final int SDL_SYSTEM_CURSOR_NS_RESIZE = 8;
    public static final int SDL_SYSTEM_CURSOR_MOVE = 9;
    public static final int SDL_SYSTEM_CURSOR_NOT_ALLOWED = 10;
    public static final int SDL_SYSTEM_CURSOR_POINTER = 11;
    public static final int SDL_SYSTEM_CURSOR_NW_RESIZE = 12;
    public static final int SDL_SYSTEM_CURSOR_N_RESIZE = 13;
    public static final int SDL_SYSTEM_CURSOR_NE_RESIZE = 14;
    public static final int SDL_SYSTEM_CURSOR_E_RESIZE = 15;
    public static final int SDL_SYSTEM_CURSOR_SE_RESIZE = 16;
    public static final int SDL_SYSTEM_CURSOR_S_RESIZE = 17;
    public static final int SDL_SYSTEM_CURSOR_SW_RESIZE = 18;
    public static final int SDL_SYSTEM_CURSOR_W_RESIZE = 19;
    public static final int SDL_SYSTEM_CURSOR_COUNT = 20;
    public static final int SDL_MOUSEWHEEL_NORMAL = 0;
    public static final int SDL_MOUSEWHEEL_FLIPPED = 1;
    public static final int SDL_BUTTON_LEFT = 1;
    public static final int SDL_BUTTON_MIDDLE = 2;
    public static final int SDL_BUTTON_RIGHT = 3;
    public static final int SDL_BUTTON_X1 = 4;
    public static final int SDL_BUTTON_X2 = 5;
    public static final int SDL_BUTTON_LMASK = SDLMouse.SDL_BUTTON_MASK(1);
    public static final int SDL_BUTTON_MMASK = SDLMouse.SDL_BUTTON_MASK(2);
    public static final int SDL_BUTTON_RMASK = SDLMouse.SDL_BUTTON_MASK(3);
    public static final int SDL_BUTTON_X1MASK = SDLMouse.SDL_BUTTON_MASK(4);
    public static final int SDL_BUTTON_X2MASK = SDLMouse.SDL_BUTTON_MASK(5);

    protected SDLMouse() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="bool")
    public static boolean SDL_HasMouse() {
        long __functionAddress = Functions.HasMouse;
        return JNI.invokeZ((long)__functionAddress);
    }

    public static long nSDL_GetMice(long count) {
        long __functionAddress = Functions.GetMice;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_MouseID *")
    public static @Nullable IntBuffer SDL_GetMice() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLMouse.nSDL_GetMice(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetMouseNameForID(int instance_id) {
        long __functionAddress = Functions.GetMouseNameForID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetMouseNameForID(@NativeType(value="SDL_MouseID") int instance_id) {
        long __result = SDLMouse.nSDL_GetMouseNameForID(instance_id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_GetMouseFocus() {
        long __functionAddress = Functions.GetMouseFocus;
        return JNI.invokeP((long)__functionAddress);
    }

    public static int nSDL_GetMouseState(long x, long y) {
        long __functionAddress = Functions.GetMouseState;
        return JNI.invokePPI((long)x, (long)y, (long)__functionAddress);
    }

    @NativeType(value="SDL_MouseButtonFlags")
    public static int SDL_GetMouseState(@NativeType(value="float *") @Nullable FloatBuffer x, @NativeType(value="float *") @Nullable FloatBuffer y) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)x, (int)1);
            Checks.checkSafe((Buffer)y, (int)1);
        }
        return SDLMouse.nSDL_GetMouseState(MemoryUtil.memAddressSafe((FloatBuffer)x), MemoryUtil.memAddressSafe((FloatBuffer)y));
    }

    public static int nSDL_GetGlobalMouseState(long x, long y) {
        long __functionAddress = Functions.GetGlobalMouseState;
        return JNI.invokePPI((long)x, (long)y, (long)__functionAddress);
    }

    @NativeType(value="SDL_MouseButtonFlags")
    public static int SDL_GetGlobalMouseState(@NativeType(value="float *") @Nullable FloatBuffer x, @NativeType(value="float *") @Nullable FloatBuffer y) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)x, (int)1);
            Checks.checkSafe((Buffer)y, (int)1);
        }
        return SDLMouse.nSDL_GetGlobalMouseState(MemoryUtil.memAddressSafe((FloatBuffer)x), MemoryUtil.memAddressSafe((FloatBuffer)y));
    }

    public static int nSDL_GetRelativeMouseState(long x, long y) {
        long __functionAddress = Functions.GetRelativeMouseState;
        return JNI.invokePPI((long)x, (long)y, (long)__functionAddress);
    }

    @NativeType(value="SDL_MouseButtonFlags")
    public static int SDL_GetRelativeMouseState(@NativeType(value="float *") @Nullable FloatBuffer x, @NativeType(value="float *") @Nullable FloatBuffer y) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)x, (int)1);
            Checks.checkSafe((Buffer)y, (int)1);
        }
        return SDLMouse.nSDL_GetRelativeMouseState(MemoryUtil.memAddressSafe((FloatBuffer)x), MemoryUtil.memAddressSafe((FloatBuffer)y));
    }

    public static void SDL_WarpMouseInWindow(@NativeType(value="SDL_Window *") long window, float x, float y) {
        long __functionAddress = Functions.WarpMouseInWindow;
        JNI.invokePV((long)window, (float)x, (float)y, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_WarpMouseGlobal(float x, float y) {
        long __functionAddress = Functions.WarpMouseGlobal;
        return JNI.invokeZ((float)x, (float)y, (long)__functionAddress);
    }

    public static boolean nSDL_SetRelativeMouseTransform(long callback, long userdata) {
        long __functionAddress = Functions.SetRelativeMouseTransform;
        return JNI.invokePPZ((long)callback, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRelativeMouseTransform(@NativeType(value="SDL_MouseMotionTransformCallback") SDL_MouseMotionTransformCallbackI callback, @NativeType(value="void *") long userdata) {
        return SDLMouse.nSDL_SetRelativeMouseTransform(callback.address(), userdata);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowRelativeMouseMode(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean enabled) {
        long __functionAddress = Functions.SetWindowRelativeMouseMode;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)enabled, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowRelativeMouseMode(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowRelativeMouseMode;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_CaptureMouse(@NativeType(value="bool") boolean enabled) {
        long __functionAddress = Functions.CaptureMouse;
        return JNI.invokeZ((boolean)enabled, (long)__functionAddress);
    }

    public static long nSDL_CreateCursor(long data, long mask, int w, int h, int hot_x, int hot_y) {
        long __functionAddress = Functions.CreateCursor;
        return JNI.invokePPP((long)data, (long)mask, (int)w, (int)h, (int)hot_x, (int)hot_y, (long)__functionAddress);
    }

    @NativeType(value="SDL_Cursor *")
    public static long SDL_CreateCursor(@NativeType(value="Uint8 const *") ByteBuffer data, @NativeType(value="Uint8 const *") ByteBuffer mask, int w, int h, int hot_x, int hot_y) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)(w * h >> 3));
            Checks.check((Buffer)mask, (int)(w * h >> 3));
        }
        return SDLMouse.nSDL_CreateCursor(MemoryUtil.memAddress((ByteBuffer)data), MemoryUtil.memAddress((ByteBuffer)mask), w, h, hot_x, hot_y);
    }

    public static long nSDL_CreateColorCursor(long surface, int hot_x, int hot_y) {
        long __functionAddress = Functions.CreateColorCursor;
        return JNI.invokePP((long)surface, (int)hot_x, (int)hot_y, (long)__functionAddress);
    }

    @NativeType(value="SDL_Cursor *")
    public static long SDL_CreateColorCursor(@NativeType(value="SDL_Surface *") SDL_Surface surface, int hot_x, int hot_y) {
        return SDLMouse.nSDL_CreateColorCursor(surface.address(), hot_x, hot_y);
    }

    public static long nSDL_CreateAnimatedCursor(long frames, int frame_count, int hot_x, int hot_y) {
        long __functionAddress = Functions.CreateAnimatedCursor;
        return JNI.invokePP((long)frames, (int)frame_count, (int)hot_x, (int)hot_y, (long)__functionAddress);
    }

    @NativeType(value="SDL_Cursor *")
    public static long SDL_CreateAnimatedCursor(@NativeType(value="SDL_CursorFrameInfo *") SDL_CursorFrameInfo.Buffer frames, int hot_x, int hot_y) {
        return SDLMouse.nSDL_CreateAnimatedCursor(frames.address(), frames.remaining(), hot_x, hot_y);
    }

    @NativeType(value="SDL_Cursor *")
    public static long SDL_CreateSystemCursor(@NativeType(value="SDL_SystemCursor") int id) {
        long __functionAddress = Functions.CreateSystemCursor;
        return JNI.invokeP((int)id, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetCursor(@NativeType(value="SDL_Cursor *") long cursor) {
        long __functionAddress = Functions.SetCursor;
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
        }
        return JNI.invokePZ((long)cursor, (long)__functionAddress);
    }

    @NativeType(value="SDL_Cursor *")
    public static long SDL_GetCursor() {
        long __functionAddress = Functions.GetCursor;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="SDL_Cursor *")
    public static long SDL_GetDefaultCursor() {
        long __functionAddress = Functions.GetDefaultCursor;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void SDL_DestroyCursor(@NativeType(value="SDL_Cursor *") long cursor) {
        long __functionAddress = Functions.DestroyCursor;
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
        }
        JNI.invokePV((long)cursor, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ShowCursor() {
        long __functionAddress = Functions.ShowCursor;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_HideCursor() {
        long __functionAddress = Functions.HideCursor;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_CursorVisible() {
        long __functionAddress = Functions.CursorVisible;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    private static int SDL_BUTTON_MASK(@NativeType(value="uint32_t") int X) {
        return 1 << X - 1;
    }

    public static final class Functions {
        public static final long HasMouse = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HasMouse");
        public static final long GetMice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetMice");
        public static final long GetMouseNameForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetMouseNameForID");
        public static final long GetMouseFocus = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetMouseFocus");
        public static final long GetMouseState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetMouseState");
        public static final long GetGlobalMouseState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetGlobalMouseState");
        public static final long GetRelativeMouseState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRelativeMouseState");
        public static final long WarpMouseInWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_WarpMouseInWindow");
        public static final long WarpMouseGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_WarpMouseGlobal");
        public static final long SetRelativeMouseTransform = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRelativeMouseTransform");
        public static final long SetWindowRelativeMouseMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowRelativeMouseMode");
        public static final long GetWindowRelativeMouseMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowRelativeMouseMode");
        public static final long CaptureMouse = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CaptureMouse");
        public static final long CreateCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateCursor");
        public static final long CreateColorCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateColorCursor");
        public static final long CreateAnimatedCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateAnimatedCursor");
        public static final long CreateSystemCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateSystemCursor");
        public static final long SetCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetCursor");
        public static final long GetCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCursor");
        public static final long GetDefaultCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDefaultCursor");
        public static final long DestroyCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyCursor");
        public static final long ShowCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ShowCursor");
        public static final long HideCursor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HideCursor");
        public static final long CursorVisible = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CursorVisible");

        private Functions() {
        }
    }
}

