/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_AppEvent_funcI;
import org.lwjgl.sdl.SDL_AppInit_funcI;
import org.lwjgl.sdl.SDL_AppIterate_funcI;
import org.lwjgl.sdl.SDL_AppQuit_funcI;
import org.lwjgl.sdl.SDL_main_funcI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class SDLMain {
    protected SDLMain() {
        throw new UnsupportedOperationException();
    }

    public static void SDL_SetMainReady() {
        long __functionAddress = Functions.SetMainReady;
        JNI.invokeV((long)__functionAddress);
    }

    public static int nSDL_RunApp(int argc, long argv, long mainFunction, long reserved) {
        long __functionAddress = Functions.RunApp;
        return JNI.invokePPPI((int)argc, (long)argv, (long)mainFunction, (long)reserved, (long)__functionAddress);
    }

    public static int SDL_RunApp(@NativeType(value="char **") @Nullable PointerBuffer argv, @NativeType(value="SDL_main_func") SDL_main_funcI mainFunction, @NativeType(value="void *") long reserved) {
        return SDLMain.nSDL_RunApp(Checks.remainingSafe((CustomBuffer)argv), MemoryUtil.memAddressSafe((Pointer)argv), mainFunction.address(), reserved);
    }

    public static int nSDL_EnterAppMainCallbacks(int argc, long argv, long appinit, long appiter, long appevent, long appquit) {
        long __functionAddress = Functions.EnterAppMainCallbacks;
        return JNI.invokePPPPPI((int)argc, (long)argv, (long)appinit, (long)appiter, (long)appevent, (long)appquit, (long)__functionAddress);
    }

    public static int SDL_EnterAppMainCallbacks(@NativeType(value="char **") @Nullable PointerBuffer argv, @NativeType(value="SDL_AppInit_func") SDL_AppInit_funcI appinit, @NativeType(value="SDL_AppIterate_func") SDL_AppIterate_funcI appiter, @NativeType(value="SDL_AppEvent_func") SDL_AppEvent_funcI appevent, @NativeType(value="SDL_AppQuit_func") SDL_AppQuit_funcI appquit) {
        return SDLMain.nSDL_EnterAppMainCallbacks(Checks.remainingSafe((CustomBuffer)argv), MemoryUtil.memAddressSafe((Pointer)argv), appinit.address(), appiter.address(), appevent.address(), appquit.address());
    }

    public static boolean nSDL_SDL_RegisterApp(long name, int style, long hInst) {
        long __functionAddress = Functions.SDL_RegisterApp;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePPZ((long)name, (int)style, (long)hInst, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SDL_RegisterApp(@NativeType(value="char *") @Nullable ByteBuffer name, @NativeType(value="Uint32") int style, @NativeType(value="HINSTANCE") long hInst) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)name);
        }
        return SDLMain.nSDL_SDL_RegisterApp(MemoryUtil.memAddressSafe((ByteBuffer)name), style, hInst);
    }

    public static void SDL_SDL_UnregisterApp() {
        long __functionAddress = Functions.SDL_UnregisterApp;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokeV((long)__functionAddress);
    }

    public static final class Functions {
        public static final long SetMainReady = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetMainReady");
        public static final long RunApp = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RunApp");
        public static final long EnterAppMainCallbacks = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EnterAppMainCallbacks");
        public static final long SDL_RegisterApp = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)SDL.getLibrary(), (String)"SDL_SDL_RegisterApp");
        public static final long SDL_UnregisterApp = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)SDL.getLibrary(), (String)"SDL_SDL_UnregisterApp");

        private Functions() {
        }
    }
}

