/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLLoadSO {
    protected SDLLoadSO() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_LoadObject(long sofile) {
        long __functionAddress = Functions.LoadObject;
        return JNI.invokePP((long)sofile, (long)__functionAddress);
    }

    @NativeType(value="SDL_SharedObject *")
    public static long SDL_LoadObject(@NativeType(value="char const *") ByteBuffer sofile) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)sofile);
        }
        return SDLLoadSO.nSDL_LoadObject(MemoryUtil.memAddress((ByteBuffer)sofile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_SharedObject *")
    public static long SDL_LoadObject(@NativeType(value="char const *") CharSequence sofile) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(sofile, true);
            long sofileEncoded = stack.getPointerAddress();
            long l = SDLLoadSO.nSDL_LoadObject(sofileEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_LoadFunction(long handle, long name) {
        long __functionAddress = Functions.LoadFunction;
        if (Checks.CHECKS) {
            Checks.check((long)handle);
        }
        return JNI.invokePPP((long)handle, (long)name, (long)__functionAddress);
    }

    @NativeType(value="SDL_FunctionPointer")
    public static long SDL_LoadFunction(@NativeType(value="SDL_SharedObject *") long handle, @NativeType(value="char *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLLoadSO.nSDL_LoadFunction(handle, MemoryUtil.memAddress((ByteBuffer)name));
    }

    public static void SDL_UnloadObject(@NativeType(value="SDL_SharedObject *") long handle) {
        long __functionAddress = Functions.UnloadObject;
        if (Checks.CHECKS) {
            Checks.check((long)handle);
        }
        JNI.invokePV((long)handle, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long LoadObject = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LoadObject");
        public static final long LoadFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LoadFunction");
        public static final long UnloadObject = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UnloadObject");

        private Functions() {
        }
    }
}

