/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLKeyboard {
    public static final int SDL_TEXTINPUT_TYPE_TEXT = 0;
    public static final int SDL_TEXTINPUT_TYPE_TEXT_NAME = 1;
    public static final int SDL_TEXTINPUT_TYPE_TEXT_EMAIL = 2;
    public static final int SDL_TEXTINPUT_TYPE_TEXT_USERNAME = 3;
    public static final int SDL_TEXTINPUT_TYPE_TEXT_PASSWORD_HIDDEN = 4;
    public static final int SDL_TEXTINPUT_TYPE_TEXT_PASSWORD_VISIBLE = 5;
    public static final int SDL_TEXTINPUT_TYPE_NUMBER = 6;
    public static final int SDL_TEXTINPUT_TYPE_NUMBER_PASSWORD_HIDDEN = 7;
    public static final int SDL_TEXTINPUT_TYPE_NUMBER_PASSWORD_VISIBLE = 8;
    public static final int SDL_CAPITALIZE_NONE = 0;
    public static final int SDL_CAPITALIZE_SENTENCES = 1;
    public static final int SDL_CAPITALIZE_WORDS = 2;
    public static final int SDL_CAPITALIZE_LETTERS = 3;
    public static final String SDL_PROP_TEXTINPUT_TYPE_NUMBER = "SDL.textinput.type";
    public static final String SDL_PROP_TEXTINPUT_CAPITALIZATION_NUMBER = "SDL.textinput.capitalization";
    public static final String SDL_PROP_TEXTINPUT_AUTOCORRECT_BOOLEAN = "SDL.textinput.autocorrect";
    public static final String SDL_PROP_TEXTINPUT_MULTILINE_BOOLEAN = "SDL.textinput.multiline";
    public static final String SDL_PROP_TEXTINPUT_ANDROID_INPUTTYPE_NUMBER = "SDL.textinput.android.inputtype";

    protected SDLKeyboard() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="bool")
    public static boolean SDL_HasKeyboard() {
        long __functionAddress = Functions.HasKeyboard;
        return JNI.invokeZ((long)__functionAddress);
    }

    public static long nSDL_GetKeyboards(long count) {
        long __functionAddress = Functions.GetKeyboards;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_KeyboardID *")
    public static @Nullable IntBuffer SDL_GetKeyboards() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLKeyboard.nSDL_GetKeyboards(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetKeyboardNameForID(int instance_id) {
        long __functionAddress = Functions.GetKeyboardNameForID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetKeyboardNameForID(@NativeType(value="SDL_KeyboardID") int instance_id) {
        long __result = SDLKeyboard.nSDL_GetKeyboardNameForID(instance_id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_GetKeyboardFocus() {
        long __functionAddress = Functions.GetKeyboardFocus;
        return JNI.invokeP((long)__functionAddress);
    }

    public static long nSDL_GetKeyboardState(long numkeys) {
        long __functionAddress = Functions.GetKeyboardState;
        return JNI.invokePP((long)numkeys, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool const *")
    public static @Nullable ByteBuffer SDL_GetKeyboardState() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer numkeys = stack.callocInt(1);
        try {
            long __result = SDLKeyboard.nSDL_GetKeyboardState(MemoryUtil.memAddress((IntBuffer)numkeys));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)numkeys.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void SDL_ResetKeyboard() {
        long __functionAddress = Functions.ResetKeyboard;
        JNI.invokeV((long)__functionAddress);
    }

    @NativeType(value="SDL_Keymod")
    public static short SDL_GetModState() {
        long __functionAddress = Functions.GetModState;
        return JNI.invokeC((long)__functionAddress);
    }

    public static void SDL_SetModState(@NativeType(value="SDL_Keymod") short modstate) {
        long __functionAddress = Functions.SetModState;
        JNI.invokeCV((short)modstate, (long)__functionAddress);
    }

    @NativeType(value="SDL_Keycode")
    public static int SDL_GetKeyFromScancode(@NativeType(value="SDL_Scancode") int scancode, @NativeType(value="SDL_Keymod") short modstate, @NativeType(value="bool") boolean key_event) {
        long __functionAddress = Functions.GetKeyFromScancode;
        return JNI.invokeCI((int)scancode, (short)modstate, (boolean)key_event, (long)__functionAddress);
    }

    public static int nSDL_GetScancodeFromKey(int key, long modstate) {
        long __functionAddress = Functions.GetScancodeFromKey;
        return JNI.invokePI((int)key, (long)modstate, (long)__functionAddress);
    }

    @NativeType(value="SDL_Scancode")
    public static int SDL_GetScancodeFromKey(@NativeType(value="SDL_Keycode") int key, @NativeType(value="SDL_Keymod *") @Nullable ShortBuffer modstate) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)modstate, (int)1);
        }
        return SDLKeyboard.nSDL_GetScancodeFromKey(key, MemoryUtil.memAddressSafe((ShortBuffer)modstate));
    }

    public static boolean nSDL_SetScancodeName(int scancode, long name) {
        long __functionAddress = Functions.SetScancodeName;
        return JNI.invokePZ((int)scancode, (long)name, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetScancodeName(@NativeType(value="SDL_Scancode") int scancode, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLKeyboard.nSDL_SetScancodeName(scancode, MemoryUtil.memAddress((ByteBuffer)name));
    }

    public static long nSDL_GetScancodeName(int scancode) {
        long __functionAddress = Functions.GetScancodeName;
        return JNI.invokeP((int)scancode, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetScancodeName(@NativeType(value="SDL_Scancode") int scancode) {
        long __result = SDLKeyboard.nSDL_GetScancodeName(scancode);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int nSDL_GetScancodeFromName(long name) {
        long __functionAddress = Functions.GetScancodeFromName;
        return JNI.invokePI((long)name, (long)__functionAddress);
    }

    @NativeType(value="SDL_Scancode")
    public static int SDL_GetScancodeFromName(@NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLKeyboard.nSDL_GetScancodeFromName(MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Scancode")
    public static int SDL_GetScancodeFromName(@NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = SDLKeyboard.nSDL_GetScancodeFromName(nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetKeyName(int key) {
        long __functionAddress = Functions.GetKeyName;
        return JNI.invokeP((int)key, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetKeyName(@NativeType(value="SDL_Keycode") int key) {
        long __result = SDLKeyboard.nSDL_GetKeyName(key);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int nSDL_GetKeyFromName(long name) {
        long __functionAddress = Functions.GetKeyFromName;
        return JNI.invokePI((long)name, (long)__functionAddress);
    }

    @NativeType(value="SDL_Keycode")
    public static int SDL_GetKeyFromName(@NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLKeyboard.nSDL_GetKeyFromName(MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Keycode")
    public static int SDL_GetKeyFromName(@NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = SDLKeyboard.nSDL_GetKeyFromName(nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="bool")
    public static boolean SDL_StartTextInput(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.StartTextInput;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_StartTextInputWithProperties(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_PropertiesID") int props) {
        long __functionAddress = Functions.StartTextInputWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)props, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_TextInputActive(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.TextInputActive;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_StopTextInput(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.StopTextInput;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ClearComposition(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.ClearComposition;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    public static boolean nSDL_SetTextInputArea(long window, long rect, int cursor) {
        long __functionAddress = Functions.SetTextInputArea;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)rect, (int)cursor, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTextInputArea(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_Rect const *")  @Nullable SDL_Rect.Buffer rect, int cursor) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)rect, (int)1);
        }
        return SDLKeyboard.nSDL_SetTextInputArea(window, MemoryUtil.memAddressSafe((Pointer)rect), cursor);
    }

    public static boolean nSDL_GetTextInputArea(long window, long rect, long cursor) {
        long __functionAddress = Functions.GetTextInputArea;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPZ((long)window, (long)rect, (long)cursor, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTextInputArea(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_Rect *")  @Nullable SDL_Rect.Buffer rect, @NativeType(value="int *") @Nullable IntBuffer cursor) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)rect, (int)1);
            Checks.checkSafe((Buffer)cursor, (int)1);
        }
        return SDLKeyboard.nSDL_GetTextInputArea(window, MemoryUtil.memAddressSafe((Pointer)rect), MemoryUtil.memAddressSafe((IntBuffer)cursor));
    }

    @NativeType(value="bool")
    public static boolean SDL_HasScreenKeyboardSupport() {
        long __functionAddress = Functions.HasScreenKeyboardSupport;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ScreenKeyboardShown(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.ScreenKeyboardShown;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long HasKeyboard = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HasKeyboard");
        public static final long GetKeyboards = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetKeyboards");
        public static final long GetKeyboardNameForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetKeyboardNameForID");
        public static final long GetKeyboardFocus = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetKeyboardFocus");
        public static final long GetKeyboardState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetKeyboardState");
        public static final long ResetKeyboard = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ResetKeyboard");
        public static final long GetModState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetModState");
        public static final long SetModState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetModState");
        public static final long GetKeyFromScancode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetKeyFromScancode");
        public static final long GetScancodeFromKey = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetScancodeFromKey");
        public static final long SetScancodeName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetScancodeName");
        public static final long GetScancodeName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetScancodeName");
        public static final long GetScancodeFromName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetScancodeFromName");
        public static final long GetKeyName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetKeyName");
        public static final long GetKeyFromName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetKeyFromName");
        public static final long StartTextInput = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_StartTextInput");
        public static final long StartTextInputWithProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_StartTextInputWithProperties");
        public static final long TextInputActive = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_TextInputActive");
        public static final long StopTextInput = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_StopTextInput");
        public static final long ClearComposition = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ClearComposition");
        public static final long SetTextInputArea = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTextInputArea");
        public static final long GetTextInputArea = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextInputArea");
        public static final long HasScreenKeyboardSupport = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HasScreenKeyboardSupport");
        public static final long ScreenKeyboardShown = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ScreenKeyboardShown");

        private Functions() {
        }
    }
}

