/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_GUID;
import org.lwjgl.sdl.SDL_VirtualJoystickDesc;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIType;
import org.lwjgl.system.libffi.LibFFI;

public class SDLJoystick {
    public static final int SDL_JOYSTICK_TYPE_UNKNOWN = 0;
    public static final int SDL_JOYSTICK_TYPE_GAMEPAD = 1;
    public static final int SDL_JOYSTICK_TYPE_WHEEL = 2;
    public static final int SDL_JOYSTICK_TYPE_ARCADE_STICK = 3;
    public static final int SDL_JOYSTICK_TYPE_FLIGHT_STICK = 4;
    public static final int SDL_JOYSTICK_TYPE_DANCE_PAD = 5;
    public static final int SDL_JOYSTICK_TYPE_GUITAR = 6;
    public static final int SDL_JOYSTICK_TYPE_DRUM_KIT = 7;
    public static final int SDL_JOYSTICK_TYPE_ARCADE_PAD = 8;
    public static final int SDL_JOYSTICK_TYPE_THROTTLE = 9;
    public static final int SDL_JOYSTICK_TYPE_COUNT = 10;
    public static final int SDL_JOYSTICK_CONNECTION_INVALID = -1;
    public static final int SDL_JOYSTICK_CONNECTION_UNKNOWN = 0;
    public static final int SDL_JOYSTICK_CONNECTION_WIRED = 1;
    public static final int SDL_JOYSTICK_CONNECTION_WIRELESS = 2;
    public static final int SDL_JOYSTICK_AXIS_MAX = Short.MAX_VALUE;
    public static final int SDL_JOYSTICK_AXIS_MIN = Short.MIN_VALUE;
    public static final String SDL_PROP_JOYSTICK_CAP_MONO_LED_BOOLEAN = "SDL.joystick.cap.mono_led";
    public static final String SDL_PROP_JOYSTICK_CAP_RGB_LED_BOOLEAN = "SDL.joystick.cap.rgb_led";
    public static final String SDL_PROP_JOYSTICK_CAP_PLAYER_LED_BOOLEAN = "SDL.joystick.cap.player_led";
    public static final String SDL_PROP_JOYSTICK_CAP_RUMBLE_BOOLEAN = "SDL.joystick.cap.rumble";
    public static final String SDL_PROP_JOYSTICK_CAP_TRIGGER_RUMBLE_BOOLEAN = "SDL.joystick.cap.trigger_rumble";
    public static final int SDL_HAT_CENTERED = 0;
    public static final int SDL_HAT_UP = 1;
    public static final int SDL_HAT_RIGHT = 2;
    public static final int SDL_HAT_DOWN = 4;
    public static final int SDL_HAT_LEFT = 8;
    public static final int SDL_HAT_RIGHTUP = 3;
    public static final int SDL_HAT_RIGHTDOWN = 6;
    public static final int SDL_HAT_LEFTUP = 9;
    public static final int SDL_HAT_LEFTDOWN = 12;
    private static final FFICIF SDL_GetJoystickGUIDForIDCIF = APIUtil.apiCreateCIF((FFIType)APIUtil.apiCreateStruct((FFIType[])new FFIType[]{APIUtil.apiCreateArray((FFIType)LibFFI.ffi_type_uint8, (int)16)}), (FFIType[])new FFIType[]{LibFFI.ffi_type_uint32});
    private static final FFICIF SDL_GetJoystickGUIDCIF = APIUtil.apiCreateCIF((FFIType)APIUtil.apiCreateStruct((FFIType[])new FFIType[]{APIUtil.apiCreateArray((FFIType)LibFFI.ffi_type_uint8, (int)16)}), (FFIType[])new FFIType[]{LibFFI.ffi_type_pointer});
    private static final FFICIF SDL_GetJoystickGUIDInfoCIF = APIUtil.apiCreateCIF((FFIType)LibFFI.ffi_type_void, (FFIType[])new FFIType[]{APIUtil.apiCreateStruct((FFIType[])new FFIType[]{APIUtil.apiCreateArray((FFIType)LibFFI.ffi_type_uint8, (int)16)}), LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer});

    protected SDLJoystick() {
        throw new UnsupportedOperationException();
    }

    public static void SDL_LockJoysticks() {
        long __functionAddress = Functions.LockJoysticks;
        JNI.invokeV((long)__functionAddress);
    }

    public static void SDL_UnlockJoysticks() {
        long __functionAddress = Functions.UnlockJoysticks;
        JNI.invokeV((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_HasJoystick() {
        long __functionAddress = Functions.HasJoystick;
        return JNI.invokeZ((long)__functionAddress);
    }

    public static long nSDL_GetJoysticks(long count) {
        long __functionAddress = Functions.GetJoysticks;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_JoystickID *")
    public static @Nullable IntBuffer SDL_GetJoysticks() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLJoystick.nSDL_GetJoysticks(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetJoystickNameForID(int instance_id) {
        long __functionAddress = Functions.GetJoystickNameForID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetJoystickNameForID(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __result = SDLJoystick.nSDL_GetJoystickNameForID(instance_id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nSDL_GetJoystickPathForID(int instance_id) {
        long __functionAddress = Functions.GetJoystickPathForID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetJoystickPathForID(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __result = SDLJoystick.nSDL_GetJoystickPathForID(instance_id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int SDL_GetJoystickPlayerIndexForID(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.GetJoystickPlayerIndexForID;
        return JNI.invokeI((int)instance_id, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nSDL_GetJoystickGUIDForID(int instance_id, long __result) {
        long __functionAddress = Functions.GetJoystickGUIDForID;
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long arguments = stack.nmalloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE * 1);
            MemoryUtil.memPutAddress((long)arguments, (long)stack.nint(instance_id));
            LibFFI.nffi_call((long)SDL_GetJoystickGUIDForIDCIF.address(), (long)__functionAddress, (long)__result, (long)arguments);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static SDL_GUID SDL_GetJoystickGUIDForID(@NativeType(value="SDL_JoystickID") int instance_id, SDL_GUID __result) {
        SDLJoystick.nSDL_GetJoystickGUIDForID(instance_id, __result.address());
        return __result;
    }

    @NativeType(value="Uint16")
    public static short SDL_GetJoystickVendorForID(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.GetJoystickVendorForID;
        return JNI.invokeC((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="Uint16")
    public static short SDL_GetJoystickProductForID(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.GetJoystickProductForID;
        return JNI.invokeC((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="Uint16")
    public static short SDL_GetJoystickProductVersionForID(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.GetJoystickProductVersionForID;
        return JNI.invokeC((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_JoystickType")
    public static int SDL_GetJoystickTypeForID(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.GetJoystickTypeForID;
        return JNI.invokeI((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_Joystick *")
    public static long SDL_OpenJoystick(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.OpenJoystick;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_Joystick *")
    public static long SDL_GetJoystickFromID(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.GetJoystickFromID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_Joystick *")
    public static long SDL_GetJoystickFromPlayerIndex(int player_index) {
        long __functionAddress = Functions.GetJoystickFromPlayerIndex;
        return JNI.invokeP((int)player_index, (long)__functionAddress);
    }

    public static int nSDL_AttachVirtualJoystick(long desc) {
        long __functionAddress = Functions.AttachVirtualJoystick;
        if (Checks.CHECKS) {
            SDL_VirtualJoystickDesc.validate(desc);
        }
        return JNI.invokePI((long)desc, (long)__functionAddress);
    }

    @NativeType(value="SDL_JoystickID")
    public static int SDL_AttachVirtualJoystick(@NativeType(value="SDL_VirtualJoystickDesc const *") SDL_VirtualJoystickDesc desc) {
        return SDLJoystick.nSDL_AttachVirtualJoystick(desc.address());
    }

    @NativeType(value="bool")
    public static boolean SDL_DetachVirtualJoystick(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.DetachVirtualJoystick;
        return JNI.invokeZ((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsJoystickVirtual(@NativeType(value="SDL_JoystickID") int instance_id) {
        long __functionAddress = Functions.IsJoystickVirtual;
        return JNI.invokeZ((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetJoystickVirtualAxis(@NativeType(value="SDL_Joystick *") long joystick, int axis, @NativeType(value="Sint16") short value) {
        long __functionAddress = Functions.SetJoystickVirtualAxis;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePSZ((long)joystick, (int)axis, (short)value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetJoystickVirtualBall(@NativeType(value="SDL_Joystick *") long joystick, int ball, @NativeType(value="Sint16") short xrel, @NativeType(value="Sint16") short yrel) {
        long __functionAddress = Functions.SetJoystickVirtualBall;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePSSZ((long)joystick, (int)ball, (short)xrel, (short)yrel, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetJoystickVirtualButton(@NativeType(value="SDL_Joystick *") long joystick, int button, @NativeType(value="bool") boolean down) {
        long __functionAddress = Functions.SetJoystickVirtualButton;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePZ((long)joystick, (int)button, (boolean)down, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetJoystickVirtualHat(@NativeType(value="SDL_Joystick *") long joystick, int hat, @NativeType(value="Uint8") byte value) {
        long __functionAddress = Functions.SetJoystickVirtualHat;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePUZ((long)joystick, (int)hat, (byte)value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetJoystickVirtualTouchpad(@NativeType(value="SDL_Joystick *") long joystick, int touchpad, int finger, @NativeType(value="bool") boolean down, float x, float y, float pressure) {
        long __functionAddress = Functions.SetJoystickVirtualTouchpad;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePZ((long)joystick, (int)touchpad, (int)finger, (boolean)down, (float)x, (float)y, (float)pressure, (long)__functionAddress);
    }

    public static boolean nSDL_SendJoystickVirtualSensorData(long joystick, int type, long sensor_timestamp, long data, int num_values) {
        long __functionAddress = Functions.SendJoystickVirtualSensorData;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePJPZ((long)joystick, (int)type, (long)sensor_timestamp, (long)data, (int)num_values, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SendJoystickVirtualSensorData(@NativeType(value="SDL_Joystick *") long joystick, @NativeType(value="SDL_SensorType") int type, @NativeType(value="Uint64") long sensor_timestamp, @NativeType(value="float const *") FloatBuffer data) {
        return SDLJoystick.nSDL_SendJoystickVirtualSensorData(joystick, type, sensor_timestamp, MemoryUtil.memAddress((FloatBuffer)data), data.remaining());
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetJoystickProperties(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickProperties;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    public static long nSDL_GetJoystickName(long joystick) {
        long __functionAddress = Functions.GetJoystickName;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePP((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetJoystickName(@NativeType(value="SDL_Joystick *") long joystick) {
        long __result = SDLJoystick.nSDL_GetJoystickName(joystick);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nSDL_GetJoystickPath(long joystick) {
        long __functionAddress = Functions.GetJoystickPath;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePP((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetJoystickPath(@NativeType(value="SDL_Joystick *") long joystick) {
        long __result = SDLJoystick.nSDL_GetJoystickPath(joystick);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int SDL_GetJoystickPlayerIndex(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickPlayerIndex;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetJoystickPlayerIndex(@NativeType(value="SDL_Joystick *") long joystick, int player_index) {
        long __functionAddress = Functions.SetJoystickPlayerIndex;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePZ((long)joystick, (int)player_index, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nSDL_GetJoystickGUID(long joystick, long __result) {
        long __functionAddress = Functions.GetJoystickGUID;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long arguments = stack.nmalloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE * 1);
            MemoryUtil.memPutAddress((long)arguments, (long)stack.npointer(joystick));
            LibFFI.nffi_call((long)SDL_GetJoystickGUIDCIF.address(), (long)__functionAddress, (long)__result, (long)arguments);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static SDL_GUID SDL_GetJoystickGUID(@NativeType(value="SDL_Joystick *") long joystick, SDL_GUID __result) {
        SDLJoystick.nSDL_GetJoystickGUID(joystick, __result.address());
        return __result;
    }

    @NativeType(value="Uint16")
    public static short SDL_GetJoystickVendor(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickVendor;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePC((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="Uint16")
    public static short SDL_GetJoystickProduct(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickProduct;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePC((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="Uint16")
    public static short SDL_GetJoystickProductVersion(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickProductVersion;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePC((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="Uint16")
    public static short SDL_GetJoystickFirmwareVersion(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickFirmwareVersion;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePC((long)joystick, (long)__functionAddress);
    }

    public static long nSDL_GetJoystickSerial(long joystick) {
        long __functionAddress = Functions.GetJoystickSerial;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePP((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetJoystickSerial(@NativeType(value="SDL_Joystick *") long joystick) {
        long __result = SDLJoystick.nSDL_GetJoystickSerial(joystick);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="SDL_JoystickType")
    public static int SDL_GetJoystickType(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickType;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nSDL_GetJoystickGUIDInfo(long guid, long vendor, long product, long version, long crc16) {
        long __functionAddress = Functions.GetJoystickGUIDInfo;
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long arguments = stack.nmalloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE * 5);
            MemoryUtil.memPutAddress((long)arguments, (long)guid);
            MemoryUtil.memPutAddress((long)(arguments + (long)MemoryStack.POINTER_SIZE), (long)stack.npointer(vendor));
            MemoryUtil.memPutAddress((long)(arguments + (long)(2 * MemoryStack.POINTER_SIZE)), (long)stack.npointer(product));
            MemoryUtil.memPutAddress((long)(arguments + (long)(3 * MemoryStack.POINTER_SIZE)), (long)stack.npointer(version));
            MemoryUtil.memPutAddress((long)(arguments + (long)(4 * MemoryStack.POINTER_SIZE)), (long)stack.npointer(crc16));
            LibFFI.nffi_call((long)SDL_GetJoystickGUIDInfoCIF.address(), (long)__functionAddress, (long)0L, (long)arguments);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void SDL_GetJoystickGUIDInfo(SDL_GUID guid, @NativeType(value="Uint16 *") @Nullable ShortBuffer vendor, @NativeType(value="Uint16 *") @Nullable ShortBuffer product, @NativeType(value="Uint16 *") @Nullable ShortBuffer version, @NativeType(value="Uint16 *") @Nullable ShortBuffer crc16) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)vendor, (int)1);
            Checks.checkSafe((Buffer)product, (int)1);
            Checks.checkSafe((Buffer)version, (int)1);
            Checks.checkSafe((Buffer)crc16, (int)1);
        }
        SDLJoystick.nSDL_GetJoystickGUIDInfo(guid.address(), MemoryUtil.memAddressSafe((ShortBuffer)vendor), MemoryUtil.memAddressSafe((ShortBuffer)product), MemoryUtil.memAddressSafe((ShortBuffer)version), MemoryUtil.memAddressSafe((ShortBuffer)crc16));
    }

    @NativeType(value="bool")
    public static boolean SDL_JoystickConnected(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.JoystickConnected;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePZ((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="SDL_JoystickID")
    public static int SDL_GetJoystickID(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickID;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    public static int SDL_GetNumJoystickAxes(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetNumJoystickAxes;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    public static int SDL_GetNumJoystickBalls(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetNumJoystickBalls;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    public static int SDL_GetNumJoystickHats(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetNumJoystickHats;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    public static int SDL_GetNumJoystickButtons(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetNumJoystickButtons;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    public static void SDL_SetJoystickEventsEnabled(@NativeType(value="bool") boolean enabled) {
        long __functionAddress = Functions.SetJoystickEventsEnabled;
        JNI.invokeV((boolean)enabled, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_JoystickEventsEnabled() {
        long __functionAddress = Functions.JoystickEventsEnabled;
        return JNI.invokeZ((long)__functionAddress);
    }

    public static void SDL_UpdateJoysticks() {
        long __functionAddress = Functions.UpdateJoysticks;
        JNI.invokeV((long)__functionAddress);
    }

    @NativeType(value="Sint16")
    public static short SDL_GetJoystickAxis(@NativeType(value="SDL_Joystick *") long joystick, int axis) {
        long __functionAddress = Functions.GetJoystickAxis;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePS((long)joystick, (int)axis, (long)__functionAddress);
    }

    public static boolean nSDL_GetJoystickAxisInitialState(long joystick, int axis, long state) {
        long __functionAddress = Functions.GetJoystickAxisInitialState;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePPZ((long)joystick, (int)axis, (long)state, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetJoystickAxisInitialState(@NativeType(value="SDL_Joystick *") long joystick, int axis, @NativeType(value="Sint16 *") @Nullable ShortBuffer state) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)state, (int)1);
        }
        return SDLJoystick.nSDL_GetJoystickAxisInitialState(joystick, axis, MemoryUtil.memAddressSafe((ShortBuffer)state));
    }

    public static boolean nSDL_GetJoystickBall(long joystick, int ball, long dx, long dy) {
        long __functionAddress = Functions.GetJoystickBall;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePPPZ((long)joystick, (int)ball, (long)dx, (long)dy, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetJoystickBall(@NativeType(value="SDL_Joystick *") long joystick, int ball, @NativeType(value="int *") @Nullable IntBuffer dx, @NativeType(value="int *") @Nullable IntBuffer dy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)dx, (int)1);
            Checks.checkSafe((Buffer)dy, (int)1);
        }
        return SDLJoystick.nSDL_GetJoystickBall(joystick, ball, MemoryUtil.memAddressSafe((IntBuffer)dx), MemoryUtil.memAddressSafe((IntBuffer)dy));
    }

    @NativeType(value="Uint8")
    public static byte SDL_GetJoystickHat(@NativeType(value="SDL_Joystick *") long joystick, int hat) {
        long __functionAddress = Functions.GetJoystickHat;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePU((long)joystick, (int)hat, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetJoystickButton(@NativeType(value="SDL_Joystick *") long joystick, int button) {
        long __functionAddress = Functions.GetJoystickButton;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePZ((long)joystick, (int)button, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RumbleJoystick(@NativeType(value="SDL_Joystick *") long joystick, @NativeType(value="Uint16") short low_frequency_rumble, @NativeType(value="Uint16") short high_frequency_rumble, @NativeType(value="Uint32") int duration_ms) {
        long __functionAddress = Functions.RumbleJoystick;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePCCZ((long)joystick, (short)low_frequency_rumble, (short)high_frequency_rumble, (int)duration_ms, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RumbleJoystickTriggers(@NativeType(value="SDL_Joystick *") long joystick, @NativeType(value="Uint16") short left_rumble, @NativeType(value="Uint16") short right_rumble, @NativeType(value="Uint32") int duration_ms) {
        long __functionAddress = Functions.RumbleJoystickTriggers;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePCCZ((long)joystick, (short)left_rumble, (short)right_rumble, (int)duration_ms, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetJoystickLED(@NativeType(value="SDL_Joystick *") long joystick, @NativeType(value="Uint8") byte red, @NativeType(value="Uint8") byte green, @NativeType(value="Uint8") byte blue) {
        long __functionAddress = Functions.SetJoystickLED;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePUUUZ((long)joystick, (byte)red, (byte)green, (byte)blue, (long)__functionAddress);
    }

    public static boolean nSDL_SendJoystickEffect(long joystick, long data, int size) {
        long __functionAddress = Functions.SendJoystickEffect;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePPZ((long)joystick, (long)data, (int)size, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SendJoystickEffect(@NativeType(value="SDL_Joystick *") long joystick, @NativeType(value="void const *") ByteBuffer data) {
        return SDLJoystick.nSDL_SendJoystickEffect(joystick, MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    public static void SDL_CloseJoystick(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.CloseJoystick;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        JNI.invokePV((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="SDL_JoystickConnectionState")
    public static int SDL_GetJoystickConnectionState(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.GetJoystickConnectionState;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePI((long)joystick, (long)__functionAddress);
    }

    public static int nSDL_GetJoystickPowerInfo(long joystick, long percent) {
        long __functionAddress = Functions.GetJoystickPowerInfo;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePPI((long)joystick, (long)percent, (long)__functionAddress);
    }

    @NativeType(value="SDL_PowerState")
    public static int SDL_GetJoystickPowerInfo(@NativeType(value="SDL_Joystick *") long joystick, @NativeType(value="int *") @Nullable IntBuffer percent) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)percent, (int)1);
        }
        return SDLJoystick.nSDL_GetJoystickPowerInfo(joystick, MemoryUtil.memAddressSafe((IntBuffer)percent));
    }

    public static void SDL_INIT_INTERFACE(SDL_VirtualJoystickDesc iface) {
        iface.clear();
        iface.version(SDL_VirtualJoystickDesc.SIZEOF);
    }

    public static final class Functions {
        public static final long LockJoysticks = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LockJoysticks");
        public static final long UnlockJoysticks = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UnlockJoysticks");
        public static final long HasJoystick = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HasJoystick");
        public static final long GetJoysticks = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoysticks");
        public static final long GetJoystickNameForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickNameForID");
        public static final long GetJoystickPathForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickPathForID");
        public static final long GetJoystickPlayerIndexForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickPlayerIndexForID");
        public static final long GetJoystickGUIDForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickGUIDForID");
        public static final long GetJoystickVendorForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickVendorForID");
        public static final long GetJoystickProductForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickProductForID");
        public static final long GetJoystickProductVersionForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickProductVersionForID");
        public static final long GetJoystickTypeForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickTypeForID");
        public static final long OpenJoystick = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_OpenJoystick");
        public static final long GetJoystickFromID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickFromID");
        public static final long GetJoystickFromPlayerIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickFromPlayerIndex");
        public static final long AttachVirtualJoystick = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_AttachVirtualJoystick");
        public static final long DetachVirtualJoystick = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DetachVirtualJoystick");
        public static final long IsJoystickVirtual = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_IsJoystickVirtual");
        public static final long SetJoystickVirtualAxis = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetJoystickVirtualAxis");
        public static final long SetJoystickVirtualBall = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetJoystickVirtualBall");
        public static final long SetJoystickVirtualButton = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetJoystickVirtualButton");
        public static final long SetJoystickVirtualHat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetJoystickVirtualHat");
        public static final long SetJoystickVirtualTouchpad = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetJoystickVirtualTouchpad");
        public static final long SendJoystickVirtualSensorData = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SendJoystickVirtualSensorData");
        public static final long GetJoystickProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickProperties");
        public static final long GetJoystickName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickName");
        public static final long GetJoystickPath = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickPath");
        public static final long GetJoystickPlayerIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickPlayerIndex");
        public static final long SetJoystickPlayerIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetJoystickPlayerIndex");
        public static final long GetJoystickGUID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickGUID");
        public static final long GetJoystickVendor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickVendor");
        public static final long GetJoystickProduct = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickProduct");
        public static final long GetJoystickProductVersion = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickProductVersion");
        public static final long GetJoystickFirmwareVersion = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickFirmwareVersion");
        public static final long GetJoystickSerial = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickSerial");
        public static final long GetJoystickType = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickType");
        public static final long GetJoystickGUIDInfo = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickGUIDInfo");
        public static final long JoystickConnected = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_JoystickConnected");
        public static final long GetJoystickID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickID");
        public static final long GetNumJoystickAxes = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumJoystickAxes");
        public static final long GetNumJoystickBalls = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumJoystickBalls");
        public static final long GetNumJoystickHats = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumJoystickHats");
        public static final long GetNumJoystickButtons = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumJoystickButtons");
        public static final long SetJoystickEventsEnabled = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetJoystickEventsEnabled");
        public static final long JoystickEventsEnabled = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_JoystickEventsEnabled");
        public static final long UpdateJoysticks = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UpdateJoysticks");
        public static final long GetJoystickAxis = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickAxis");
        public static final long GetJoystickAxisInitialState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickAxisInitialState");
        public static final long GetJoystickBall = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickBall");
        public static final long GetJoystickHat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickHat");
        public static final long GetJoystickButton = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickButton");
        public static final long RumbleJoystick = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RumbleJoystick");
        public static final long RumbleJoystickTriggers = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RumbleJoystickTriggers");
        public static final long SetJoystickLED = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetJoystickLED");
        public static final long SendJoystickEffect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SendJoystickEffect");
        public static final long CloseJoystick = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CloseJoystick");
        public static final long GetJoystickConnectionState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickConnectionState");
        public static final long GetJoystickPowerInfo = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetJoystickPowerInfo");

        private Functions() {
        }
    }
}

