/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_HapticEffect;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLHaptic {
    public static final int SDL_HAPTIC_INFINITY = -1;
    public static final int SDL_HAPTIC_CONSTANT = 1;
    public static final int SDL_HAPTIC_SINE = 2;
    public static final int SDL_HAPTIC_SQUARE = 4;
    public static final int SDL_HAPTIC_TRIANGLE = 8;
    public static final int SDL_HAPTIC_SAWTOOTHUP = 16;
    public static final int SDL_HAPTIC_SAWTOOTHDOWN = 32;
    public static final int SDL_HAPTIC_RAMP = 64;
    public static final int SDL_HAPTIC_SPRING = 128;
    public static final int SDL_HAPTIC_DAMPER = 256;
    public static final int SDL_HAPTIC_INERTIA = 512;
    public static final int SDL_HAPTIC_FRICTION = 1024;
    public static final int SDL_HAPTIC_LEFTRIGHT = 2048;
    public static final int SDL_HAPTIC_RESERVED1 = 4096;
    public static final int SDL_HAPTIC_RESERVED2 = 8192;
    public static final int SDL_HAPTIC_RESERVED3 = 16384;
    public static final int SDL_HAPTIC_CUSTOM = 32768;
    public static final int SDL_HAPTIC_GAIN = 65536;
    public static final int SDL_HAPTIC_AUTOCENTER = 131072;
    public static final int SDL_HAPTIC_STATUS = 262144;
    public static final int SDL_HAPTIC_PAUSE = 524288;
    public static final int SDL_HAPTIC_POLAR = 0;
    public static final int SDL_HAPTIC_CARTESIAN = 1;
    public static final int SDL_HAPTIC_SPHERICAL = 2;
    public static final int SDL_HAPTIC_STEERING_AXIS = 3;

    protected SDLHaptic() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_GetHaptics(long count) {
        long __functionAddress = Functions.GetHaptics;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_HapticID *")
    public static @Nullable IntBuffer SDL_GetHaptics() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLHaptic.nSDL_GetHaptics(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetHapticNameForID(int instance_id) {
        long __functionAddress = Functions.GetHapticNameForID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetHapticNameForID(@NativeType(value="SDL_HapticID") int instance_id) {
        long __result = SDLHaptic.nSDL_GetHapticNameForID(instance_id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="SDL_Haptic *")
    public static long SDL_OpenHaptic(@NativeType(value="SDL_HapticID") int instance_id) {
        long __functionAddress = Functions.OpenHaptic;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_Haptic *")
    public static long SDL_GetHapticFromID(@NativeType(value="SDL_HapticID") int instance_id) {
        long __functionAddress = Functions.GetHapticFromID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_HapticID")
    public static int SDL_GetHapticID(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.GetHapticID;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePI((long)haptic, (long)__functionAddress);
    }

    public static long nSDL_GetHapticName(long haptic) {
        long __functionAddress = Functions.GetHapticName;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePP((long)haptic, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetHapticName(@NativeType(value="SDL_Haptic *") long haptic) {
        long __result = SDLHaptic.nSDL_GetHapticName(haptic);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsMouseHaptic() {
        long __functionAddress = Functions.IsMouseHaptic;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="SDL_Haptic *")
    public static long SDL_OpenHapticFromMouse() {
        long __functionAddress = Functions.OpenHapticFromMouse;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsJoystickHaptic(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.IsJoystickHaptic;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePZ((long)joystick, (long)__functionAddress);
    }

    @NativeType(value="SDL_Haptic *")
    public static long SDL_OpenHapticFromJoystick(@NativeType(value="SDL_Joystick *") long joystick) {
        long __functionAddress = Functions.OpenHapticFromJoystick;
        if (Checks.CHECKS) {
            Checks.check((long)joystick);
        }
        return JNI.invokePP((long)joystick, (long)__functionAddress);
    }

    public static void SDL_CloseHaptic(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.CloseHaptic;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        JNI.invokePV((long)haptic, (long)__functionAddress);
    }

    public static int SDL_GetMaxHapticEffects(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.GetMaxHapticEffects;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePI((long)haptic, (long)__functionAddress);
    }

    public static int SDL_GetMaxHapticEffectsPlaying(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.GetMaxHapticEffectsPlaying;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePI((long)haptic, (long)__functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_GetHapticFeatures(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.GetHapticFeatures;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePI((long)haptic, (long)__functionAddress);
    }

    public static int SDL_GetNumHapticAxes(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.GetNumHapticAxes;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePI((long)haptic, (long)__functionAddress);
    }

    public static boolean nSDL_HapticEffectSupported(long haptic, long effect) {
        long __functionAddress = Functions.HapticEffectSupported;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePPZ((long)haptic, (long)effect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_HapticEffectSupported(@NativeType(value="SDL_Haptic *") long haptic, @NativeType(value="SDL_HapticEffect const *") SDL_HapticEffect effect) {
        return SDLHaptic.nSDL_HapticEffectSupported(haptic, effect.address());
    }

    public static int nSDL_CreateHapticEffect(long haptic, long effect) {
        long __functionAddress = Functions.CreateHapticEffect;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePPI((long)haptic, (long)effect, (long)__functionAddress);
    }

    @NativeType(value="SDL_HapticEffectID")
    public static int SDL_CreateHapticEffect(@NativeType(value="SDL_Haptic *") long haptic, @NativeType(value="SDL_HapticEffect const *") SDL_HapticEffect effect) {
        return SDLHaptic.nSDL_CreateHapticEffect(haptic, effect.address());
    }

    public static boolean nSDL_UpdateHapticEffect(long haptic, int effect, long data) {
        long __functionAddress = Functions.UpdateHapticEffect;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePPZ((long)haptic, (int)effect, (long)data, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_UpdateHapticEffect(@NativeType(value="SDL_Haptic *") long haptic, @NativeType(value="SDL_HapticEffectID") int effect, @NativeType(value="SDL_HapticEffect const *") SDL_HapticEffect data) {
        return SDLHaptic.nSDL_UpdateHapticEffect(haptic, effect, data.address());
    }

    @NativeType(value="bool")
    public static boolean SDL_RunHapticEffect(@NativeType(value="SDL_Haptic *") long haptic, @NativeType(value="SDL_HapticEffectID") int effect, @NativeType(value="Uint32") int iterations) {
        long __functionAddress = Functions.RunHapticEffect;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (int)effect, (int)iterations, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_StopHapticEffect(@NativeType(value="SDL_Haptic *") long haptic, @NativeType(value="SDL_HapticEffectID") int effect) {
        long __functionAddress = Functions.StopHapticEffect;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (int)effect, (long)__functionAddress);
    }

    public static void SDL_DestroyHapticEffect(@NativeType(value="SDL_Haptic *") long haptic, @NativeType(value="SDL_HapticEffectID") int effect) {
        long __functionAddress = Functions.DestroyHapticEffect;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        JNI.invokePV((long)haptic, (int)effect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetHapticEffectStatus(@NativeType(value="SDL_Haptic *") long haptic, @NativeType(value="SDL_HapticEffectID") int effect) {
        long __functionAddress = Functions.GetHapticEffectStatus;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (int)effect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetHapticGain(@NativeType(value="SDL_Haptic *") long haptic, int gain) {
        long __functionAddress = Functions.SetHapticGain;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (int)gain, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetHapticAutocenter(@NativeType(value="SDL_Haptic *") long haptic, int autocenter) {
        long __functionAddress = Functions.SetHapticAutocenter;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (int)autocenter, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PauseHaptic(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.PauseHaptic;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ResumeHaptic(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.ResumeHaptic;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_StopHapticEffects(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.StopHapticEffects;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_HapticRumbleSupported(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.HapticRumbleSupported;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_InitHapticRumble(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.InitHapticRumble;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PlayHapticRumble(@NativeType(value="SDL_Haptic *") long haptic, float strength, @NativeType(value="Uint32") int length) {
        long __functionAddress = Functions.PlayHapticRumble;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (float)strength, (int)length, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_StopHapticRumble(@NativeType(value="SDL_Haptic *") long haptic) {
        long __functionAddress = Functions.StopHapticRumble;
        if (Checks.CHECKS) {
            Checks.check((long)haptic);
        }
        return JNI.invokePZ((long)haptic, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetHaptics = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetHaptics");
        public static final long GetHapticNameForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetHapticNameForID");
        public static final long OpenHaptic = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_OpenHaptic");
        public static final long GetHapticFromID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetHapticFromID");
        public static final long GetHapticID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetHapticID");
        public static final long GetHapticName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetHapticName");
        public static final long IsMouseHaptic = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_IsMouseHaptic");
        public static final long OpenHapticFromMouse = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_OpenHapticFromMouse");
        public static final long IsJoystickHaptic = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_IsJoystickHaptic");
        public static final long OpenHapticFromJoystick = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_OpenHapticFromJoystick");
        public static final long CloseHaptic = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CloseHaptic");
        public static final long GetMaxHapticEffects = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetMaxHapticEffects");
        public static final long GetMaxHapticEffectsPlaying = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetMaxHapticEffectsPlaying");
        public static final long GetHapticFeatures = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetHapticFeatures");
        public static final long GetNumHapticAxes = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumHapticAxes");
        public static final long HapticEffectSupported = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HapticEffectSupported");
        public static final long CreateHapticEffect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateHapticEffect");
        public static final long UpdateHapticEffect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UpdateHapticEffect");
        public static final long RunHapticEffect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RunHapticEffect");
        public static final long StopHapticEffect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_StopHapticEffect");
        public static final long DestroyHapticEffect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyHapticEffect");
        public static final long GetHapticEffectStatus = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetHapticEffectStatus");
        public static final long SetHapticGain = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetHapticGain");
        public static final long SetHapticAutocenter = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetHapticAutocenter");
        public static final long PauseHaptic = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_PauseHaptic");
        public static final long ResumeHaptic = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ResumeHaptic");
        public static final long StopHapticEffects = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_StopHapticEffects");
        public static final long HapticRumbleSupported = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HapticRumbleSupported");
        public static final long InitHapticRumble = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_InitHapticRumble");
        public static final long PlayHapticRumble = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_PlayHapticRumble");
        public static final long StopHapticRumble = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_StopHapticRumble");

        private Functions() {
        }
    }
}

