/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_GUID;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIType;
import org.lwjgl.system.libffi.LibFFI;

public class SDLGUID {
    private static final FFICIF SDL_GUIDToStringCIF = APIUtil.apiCreateCIF((FFIType)LibFFI.ffi_type_void, (FFIType[])new FFIType[]{APIUtil.apiCreateStruct((FFIType[])new FFIType[]{APIUtil.apiCreateArray((FFIType)LibFFI.ffi_type_uint8, (int)16)}), LibFFI.ffi_type_pointer, LibFFI.ffi_type_sint32});
    private static final FFICIF SDL_StringToGUIDCIF = APIUtil.apiCreateCIF((FFIType)APIUtil.apiCreateStruct((FFIType[])new FFIType[]{APIUtil.apiCreateArray((FFIType)LibFFI.ffi_type_uint8, (int)16)}), (FFIType[])new FFIType[]{LibFFI.ffi_type_pointer});

    protected SDLGUID() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nSDL_GUIDToString(long guid, long pszGUID, int cbGUID) {
        long __functionAddress = Functions.GUIDToString;
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long arguments = stack.nmalloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE * 3);
            MemoryUtil.memPutAddress((long)arguments, (long)guid);
            MemoryUtil.memPutAddress((long)(arguments + (long)MemoryStack.POINTER_SIZE), (long)stack.npointer(pszGUID));
            MemoryUtil.memPutAddress((long)(arguments + (long)(2 * MemoryStack.POINTER_SIZE)), (long)stack.nint(cbGUID));
            LibFFI.nffi_call((long)SDL_GUIDToStringCIF.address(), (long)__functionAddress, (long)0L, (long)arguments);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void SDL_GUIDToString(SDL_GUID guid, @NativeType(value="char *") ByteBuffer pszGUID) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pszGUID, (int)33);
        }
        SDLGUID.nSDL_GUIDToString(guid.address(), MemoryUtil.memAddress((ByteBuffer)pszGUID), pszGUID.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nSDL_StringToGUID(long pchGUID, long __result) {
        long __functionAddress = Functions.StringToGUID;
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long arguments = stack.nmalloc(MemoryStack.POINTER_SIZE, MemoryStack.POINTER_SIZE * 1);
            MemoryUtil.memPutAddress((long)arguments, (long)stack.npointer(pchGUID));
            LibFFI.nffi_call((long)SDL_StringToGUIDCIF.address(), (long)__functionAddress, (long)__result, (long)arguments);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static SDL_GUID SDL_StringToGUID(@NativeType(value="char const *") ByteBuffer pchGUID, SDL_GUID __result) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchGUID);
        }
        SDLGUID.nSDL_StringToGUID(MemoryUtil.memAddress((ByteBuffer)pchGUID), __result.address());
        return __result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SDL_GUID SDL_StringToGUID(@NativeType(value="char const *") CharSequence pchGUID, SDL_GUID __result) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchGUID, true);
            long pchGUIDEncoded = stack.getPointerAddress();
            SDLGUID.nSDL_StringToGUID(pchGUIDEncoded, __result.address());
            SDL_GUID sDL_GUID = __result;
            return sDL_GUID;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long GUIDToString = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GUIDToString");
        public static final long StringToGUID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_StringToGUID");

        private Functions() {
        }
    }
}

