/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDLStdinc;
import org.lwjgl.sdl.SDL_EnumerateDirectoryCallbackI;
import org.lwjgl.sdl.SDL_PathInfo;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLFileSystem {
    public static final int SDL_FOLDER_HOME = 0;
    public static final int SDL_FOLDER_DESKTOP = 1;
    public static final int SDL_FOLDER_DOCUMENTS = 2;
    public static final int SDL_FOLDER_DOWNLOADS = 3;
    public static final int SDL_FOLDER_MUSIC = 4;
    public static final int SDL_FOLDER_PICTURES = 5;
    public static final int SDL_FOLDER_PUBLICSHARE = 6;
    public static final int SDL_FOLDER_SAVEDGAMES = 7;
    public static final int SDL_FOLDER_SCREENSHOTS = 8;
    public static final int SDL_FOLDER_TEMPLATES = 9;
    public static final int SDL_FOLDER_VIDEOS = 10;
    public static final int SDL_FOLDER_COUNT = 11;
    public static final int SDL_PATHTYPE_NONE = 0;
    public static final int SDL_PATHTYPE_FILE = 1;
    public static final int SDL_PATHTYPE_DIRECTORY = 2;
    public static final int SDL_PATHTYPE_OTHER = 3;
    public static final int SDL_ENUM_CONTINUE = 0;
    public static final int SDL_ENUM_SUCCESS = 1;
    public static final int SDL_ENUM_FAILURE = 2;

    protected SDLFileSystem() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_GetBasePath() {
        long __functionAddress = Functions.GetBasePath;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetBasePath() {
        long __result = SDLFileSystem.nSDL_GetBasePath();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nSDL_GetPrefPath(long org, long app) {
        long __functionAddress = Functions.GetPrefPath;
        return JNI.invokePPP((long)org, (long)app, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char *")
    public static @Nullable String SDL_GetPrefPath(@NativeType(value="char const *") ByteBuffer org, @NativeType(value="char const *") ByteBuffer app) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)org);
            Checks.checkNT1((ByteBuffer)app);
        }
        long __result = 0L;
        try {
            __result = SDLFileSystem.nSDL_GetPrefPath(MemoryUtil.memAddress((ByteBuffer)org), MemoryUtil.memAddress((ByteBuffer)app));
            String string = MemoryUtil.memUTF8Safe((long)__result);
            return string;
        }
        finally {
            SDLStdinc.nSDL_free(__result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char *")
    public static @Nullable String SDL_GetPrefPath(@NativeType(value="char const *") CharSequence org, @NativeType(value="char const *") CharSequence app) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        long __result = 0L;
        try {
            stack.nUTF8(org, true);
            long orgEncoded = stack.getPointerAddress();
            stack.nUTF8(app, true);
            long appEncoded = stack.getPointerAddress();
            __result = SDLFileSystem.nSDL_GetPrefPath(orgEncoded, appEncoded);
            String string = MemoryUtil.memUTF8Safe((long)__result);
            return string;
        }
        finally {
            SDLStdinc.nSDL_free(__result);
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetUserFolder(int folder) {
        long __functionAddress = Functions.GetUserFolder;
        return JNI.invokeP((int)folder, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetUserFolder(@NativeType(value="SDL_Folder") int folder) {
        long __result = SDLFileSystem.nSDL_GetUserFolder(folder);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static boolean nSDL_CreateDirectory(long path) {
        long __functionAddress = Functions.CreateDirectory;
        return JNI.invokePZ((long)path, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_CreateDirectory(@NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
        }
        return SDLFileSystem.nSDL_CreateDirectory(MemoryUtil.memAddress((ByteBuffer)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_CreateDirectory(@NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLFileSystem.nSDL_CreateDirectory(pathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_EnumerateDirectory(long path, long callback, long userdata) {
        long __functionAddress = Functions.EnumerateDirectory;
        return JNI.invokePPPZ((long)path, (long)callback, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_EnumerateDirectory(@NativeType(value="char const *") ByteBuffer path, @NativeType(value="SDL_EnumerateDirectoryCallback") SDL_EnumerateDirectoryCallbackI callback, @NativeType(value="void *") long userdata) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
        }
        return SDLFileSystem.nSDL_EnumerateDirectory(MemoryUtil.memAddress((ByteBuffer)path), callback.address(), userdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_EnumerateDirectory(@NativeType(value="char const *") CharSequence path, @NativeType(value="SDL_EnumerateDirectoryCallback") SDL_EnumerateDirectoryCallbackI callback, @NativeType(value="void *") long userdata) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLFileSystem.nSDL_EnumerateDirectory(pathEncoded, callback.address(), userdata);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_RemovePath(long path) {
        long __functionAddress = Functions.RemovePath;
        return JNI.invokePZ((long)path, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RemovePath(@NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
        }
        return SDLFileSystem.nSDL_RemovePath(MemoryUtil.memAddress((ByteBuffer)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_RemovePath(@NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLFileSystem.nSDL_RemovePath(pathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_RenamePath(long oldpath, long newpath) {
        long __functionAddress = Functions.RenamePath;
        return JNI.invokePPZ((long)oldpath, (long)newpath, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenamePath(@NativeType(value="char const *") ByteBuffer oldpath, @NativeType(value="char const *") ByteBuffer newpath) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)oldpath);
            Checks.checkNT1((ByteBuffer)newpath);
        }
        return SDLFileSystem.nSDL_RenamePath(MemoryUtil.memAddress((ByteBuffer)oldpath), MemoryUtil.memAddress((ByteBuffer)newpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_RenamePath(@NativeType(value="char const *") CharSequence oldpath, @NativeType(value="char const *") CharSequence newpath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(oldpath, true);
            long oldpathEncoded = stack.getPointerAddress();
            stack.nUTF8(newpath, true);
            long newpathEncoded = stack.getPointerAddress();
            boolean bl = SDLFileSystem.nSDL_RenamePath(oldpathEncoded, newpathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_CopyFile(long oldpath, long newpath) {
        long __functionAddress = Functions.CopyFile;
        return JNI.invokePPZ((long)oldpath, (long)newpath, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_CopyFile(@NativeType(value="char const *") ByteBuffer oldpath, @NativeType(value="char const *") ByteBuffer newpath) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)oldpath);
            Checks.checkNT1((ByteBuffer)newpath);
        }
        return SDLFileSystem.nSDL_CopyFile(MemoryUtil.memAddress((ByteBuffer)oldpath), MemoryUtil.memAddress((ByteBuffer)newpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_CopyFile(@NativeType(value="char const *") CharSequence oldpath, @NativeType(value="char const *") CharSequence newpath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(oldpath, true);
            long oldpathEncoded = stack.getPointerAddress();
            stack.nUTF8(newpath, true);
            long newpathEncoded = stack.getPointerAddress();
            boolean bl = SDLFileSystem.nSDL_CopyFile(oldpathEncoded, newpathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_GetPathInfo(long path, long info) {
        long __functionAddress = Functions.GetPathInfo;
        return JNI.invokePPZ((long)path, (long)info, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetPathInfo(@NativeType(value="char const *") ByteBuffer path, @NativeType(value="SDL_PathInfo *") @Nullable SDL_PathInfo info) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
        }
        return SDLFileSystem.nSDL_GetPathInfo(MemoryUtil.memAddress((ByteBuffer)path), MemoryUtil.memAddressSafe((Pointer)info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_GetPathInfo(@NativeType(value="char const *") CharSequence path, @NativeType(value="SDL_PathInfo *") @Nullable SDL_PathInfo info) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLFileSystem.nSDL_GetPathInfo(pathEncoded, MemoryUtil.memAddressSafe((Pointer)info));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GlobDirectory(long path, long pattern, int flags, long count) {
        long __functionAddress = Functions.GlobDirectory;
        return JNI.invokePPPP((long)path, (long)pattern, (int)flags, (long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char **")
    public static @Nullable PointerBuffer SDL_GlobDirectory(@NativeType(value="char const *") ByteBuffer path, @NativeType(value="char const *") @Nullable ByteBuffer pattern, @NativeType(value="SDL_GlobFlags") int flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
            Checks.checkNT1Safe((ByteBuffer)pattern);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLFileSystem.nSDL_GlobDirectory(MemoryUtil.memAddress((ByteBuffer)path), MemoryUtil.memAddressSafe((ByteBuffer)pattern), flags, MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char **")
    public static @Nullable PointerBuffer SDL_GlobDirectory(@NativeType(value="char const *") CharSequence path, @NativeType(value="char const *") @Nullable CharSequence pattern, @NativeType(value="SDL_GlobFlags") int flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer count = stack.callocInt(1);
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            stack.nUTF8Safe(pattern, true);
            long patternEncoded = pattern == null ? 0L : stack.getPointerAddress();
            long __result = SDLFileSystem.nSDL_GlobDirectory(pathEncoded, patternEncoded, flags, MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetCurrentDirectory() {
        long __functionAddress = Functions.GetCurrentDirectory;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="char *")
    public static @Nullable String SDL_GetCurrentDirectory() {
        long __result = 0L;
        try {
            __result = SDLFileSystem.nSDL_GetCurrentDirectory();
            String string = MemoryUtil.memUTF8Safe((long)__result);
            return string;
        }
        finally {
            SDLStdinc.nSDL_free(__result);
        }
    }

    public static final class Functions {
        public static final long GetBasePath = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetBasePath");
        public static final long GetPrefPath = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetPrefPath");
        public static final long GetUserFolder = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetUserFolder");
        public static final long CreateDirectory = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateDirectory");
        public static final long EnumerateDirectory = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EnumerateDirectory");
        public static final long RemovePath = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RemovePath");
        public static final long RenamePath = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenamePath");
        public static final long CopyFile = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CopyFile");
        public static final long GetPathInfo = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetPathInfo");
        public static final long GlobDirectory = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GlobDirectory");
        public static final long GetCurrentDirectory = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCurrentDirectory");

        private Functions() {
        }
    }
}

