/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_CameraSpec;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLCamera {
    public static final int SDL_CAMERA_POSITION_UNKNOWN = 0;
    public static final int SDL_CAMERA_POSITION_FRONT_FACING = 1;
    public static final int SDL_CAMERA_POSITION_BACK_FACING = 2;
    public static final int SDL_CAMERA_PERMISSION_STATE_DENIED = -1;
    public static final int SDL_CAMERA_PERMISSION_STATE_PENDING = 0;
    public static final int SDL_CAMERA_PERMISSION_STATE_APPROVED = 1;

    protected SDLCamera() {
        throw new UnsupportedOperationException();
    }

    public static int SDL_GetNumCameraDrivers() {
        long __functionAddress = Functions.GetNumCameraDrivers;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long nSDL_GetCameraDriver(int index) {
        long __functionAddress = Functions.GetCameraDriver;
        return JNI.invokeP((int)index, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetCameraDriver(int index) {
        long __result = SDLCamera.nSDL_GetCameraDriver(index);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static long nSDL_GetCurrentCameraDriver() {
        long __functionAddress = Functions.GetCurrentCameraDriver;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetCurrentCameraDriver() {
        long __result = SDLCamera.nSDL_GetCurrentCameraDriver();
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static long nSDL_GetCameras(long count) {
        long __functionAddress = Functions.GetCameras;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_CameraID *")
    public static @Nullable IntBuffer SDL_GetCameras() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLCamera.nSDL_GetCameras(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetCameraSupportedFormats(int instance_id, long count) {
        long __functionAddress = Functions.GetCameraSupportedFormats;
        return JNI.invokePP((int)instance_id, (long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_CameraSpec **")
    public static @Nullable PointerBuffer SDL_GetCameraSupportedFormats(@NativeType(value="SDL_CameraID") int instance_id) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLCamera.nSDL_GetCameraSupportedFormats(instance_id, MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetCameraName(int instance_id) {
        long __functionAddress = Functions.GetCameraName;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetCameraName(@NativeType(value="SDL_CameraID") int instance_id) {
        long __result = SDLCamera.nSDL_GetCameraName(instance_id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="SDL_CameraPosition")
    public static int SDL_GetCameraPosition(@NativeType(value="SDL_CameraID") int instance_id) {
        long __functionAddress = Functions.GetCameraPosition;
        return JNI.invokeI((int)instance_id, (long)__functionAddress);
    }

    public static long nSDL_OpenCamera(int instance_id, long spec) {
        long __functionAddress = Functions.OpenCamera;
        return JNI.invokePP((int)instance_id, (long)spec, (long)__functionAddress);
    }

    @NativeType(value="SDL_Camera *")
    public static long SDL_OpenCamera(@NativeType(value="SDL_CameraID") int instance_id, @NativeType(value="SDL_CameraSpec const *") @Nullable SDL_CameraSpec spec) {
        return SDLCamera.nSDL_OpenCamera(instance_id, MemoryUtil.memAddressSafe((Pointer)spec));
    }

    @NativeType(value="SDL_CameraPermissionState")
    public static int SDL_GetCameraPermissionState(@NativeType(value="SDL_Camera *") long camera) {
        long __functionAddress = Functions.GetCameraPermissionState;
        if (Checks.CHECKS) {
            Checks.check((long)camera);
        }
        return JNI.invokePI((long)camera, (long)__functionAddress);
    }

    @NativeType(value="SDL_CameraID")
    public static int SDL_GetCameraID(@NativeType(value="SDL_Camera *") long camera) {
        long __functionAddress = Functions.GetCameraID;
        if (Checks.CHECKS) {
            Checks.check((long)camera);
        }
        return JNI.invokePI((long)camera, (long)__functionAddress);
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetCameraProperties(@NativeType(value="SDL_Camera *") long camera) {
        long __functionAddress = Functions.GetCameraProperties;
        if (Checks.CHECKS) {
            Checks.check((long)camera);
        }
        return JNI.invokePI((long)camera, (long)__functionAddress);
    }

    public static boolean nSDL_GetCameraFormat(long camera, long spec) {
        long __functionAddress = Functions.GetCameraFormat;
        if (Checks.CHECKS) {
            Checks.check((long)camera);
        }
        return JNI.invokePPZ((long)camera, (long)spec, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetCameraFormat(@NativeType(value="SDL_Camera *") long camera, @NativeType(value="SDL_CameraSpec *") SDL_CameraSpec spec) {
        return SDLCamera.nSDL_GetCameraFormat(camera, spec.address());
    }

    public static long nSDL_AcquireCameraFrame(long camera, long timestampNS) {
        long __functionAddress = Functions.AcquireCameraFrame;
        if (Checks.CHECKS) {
            Checks.check((long)camera);
        }
        return JNI.invokePPP((long)camera, (long)timestampNS, (long)__functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_AcquireCameraFrame(@NativeType(value="SDL_Camera *") long camera, @NativeType(value="Uint64 *") @Nullable LongBuffer timestampNS) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)timestampNS, (int)1);
        }
        long __result = SDLCamera.nSDL_AcquireCameraFrame(camera, MemoryUtil.memAddressSafe((LongBuffer)timestampNS));
        return SDL_Surface.createSafe(__result);
    }

    public static void nSDL_ReleaseCameraFrame(long camera, long frame) {
        long __functionAddress = Functions.ReleaseCameraFrame;
        if (Checks.CHECKS) {
            Checks.check((long)camera);
        }
        JNI.invokePPV((long)camera, (long)frame, (long)__functionAddress);
    }

    public static void SDL_ReleaseCameraFrame(@NativeType(value="SDL_Camera *") long camera, @NativeType(value="SDL_Surface *") SDL_Surface frame) {
        SDLCamera.nSDL_ReleaseCameraFrame(camera, frame.address());
    }

    public static void SDL_CloseCamera(@NativeType(value="SDL_Camera *") long camera) {
        long __functionAddress = Functions.CloseCamera;
        if (Checks.CHECKS) {
            Checks.check((long)camera);
        }
        JNI.invokePV((long)camera, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetNumCameraDrivers = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumCameraDrivers");
        public static final long GetCameraDriver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameraDriver");
        public static final long GetCurrentCameraDriver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCurrentCameraDriver");
        public static final long GetCameras = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameras");
        public static final long GetCameraSupportedFormats = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameraSupportedFormats");
        public static final long GetCameraName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameraName");
        public static final long GetCameraPosition = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameraPosition");
        public static final long OpenCamera = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_OpenCamera");
        public static final long GetCameraPermissionState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameraPermissionState");
        public static final long GetCameraID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameraID");
        public static final long GetCameraProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameraProperties");
        public static final long GetCameraFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCameraFormat");
        public static final long AcquireCameraFrame = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_AcquireCameraFrame");
        public static final long ReleaseCameraFrame = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ReleaseCameraFrame");
        public static final long CloseCamera = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CloseCamera");

        private Functions() {
        }
    }
}

