/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_AudioPostmixCallbackI;
import org.lwjgl.sdl.SDL_AudioSpec;
import org.lwjgl.sdl.SDL_AudioStreamCallbackI;
import org.lwjgl.sdl.SDL_AudioStreamDataCompleteCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLAudio {
    public static final int SDL_AUDIO_MASK_BITSIZE = 255;
    public static final int SDL_AUDIO_MASK_FLOAT = 256;
    public static final int SDL_AUDIO_MASK_BIG_ENDIAN = 4096;
    public static final int SDL_AUDIO_MASK_SIGNED = 32768;
    public static final int SDL_AUDIO_UNKNOWN = 0;
    public static final int SDL_AUDIO_U8 = 8;
    public static final int SDL_AUDIO_S8 = 32776;
    public static final int SDL_AUDIO_S16LE = 32784;
    public static final int SDL_AUDIO_S16BE = 36880;
    public static final int SDL_AUDIO_S32LE = 32800;
    public static final int SDL_AUDIO_S32BE = 36896;
    public static final int SDL_AUDIO_F32LE = 33056;
    public static final int SDL_AUDIO_F32BE = 37152;
    public static final int SDL_AUDIO_S16 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 32784 : 36880;
    public static final int SDL_AUDIO_S32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 32800 : 36896;
    public static final int SDL_AUDIO_F32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 33056 : 37152;
    public static final int SDL_AUDIO_DEVICE_DEFAULT_PLAYBACK = -1;
    public static final int SDL_AUDIO_DEVICE_DEFAULT_RECORDING = -2;
    public static final String SDL_PROP_AUDIOSTREAM_AUTO_CLEANUP_BOOLEAN = "SDL.audiostream.auto_cleanup";

    protected SDLAudio() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="uint32_t")
    public static int SDL_DEFINE_AUDIO_FORMAT(@NativeType(value="uint32_t") int signed, @NativeType(value="uint32_t") int bigendian, @NativeType(value="uint32_t") int flt, @NativeType(value="uint32_t") int size) {
        return (signed & 1) << 15 | (bigendian & 1) << 12 | (flt & 1) << 8 | size & 0xFF;
    }

    @NativeType(value="uint32_t")
    public static int SDL_AUDIO_BITSIZE(@NativeType(value="SDL_AudioFormat") int x) {
        return x & 0xFF;
    }

    @NativeType(value="uint32_t")
    public static int SDL_AUDIO_BYTESIZE(@NativeType(value="SDL_AudioFormat") int x) {
        return SDLAudio.SDL_AUDIO_BITSIZE(x) / 8;
    }

    @NativeType(value="bool")
    public static boolean SDL_AUDIO_ISFLOAT(@NativeType(value="SDL_AudioFormat") int x) {
        return (x & 0x100) != 0;
    }

    @NativeType(value="bool")
    public static boolean SDL_AUDIO_ISBIGENDIAN(@NativeType(value="SDL_AudioFormat") int x) {
        return (x & 0x1000) != 0;
    }

    @NativeType(value="bool")
    public static boolean SDL_AUDIO_ISLITTLEENDIAN(@NativeType(value="SDL_AudioFormat") int x) {
        return !SDLAudio.SDL_AUDIO_ISBIGENDIAN(x);
    }

    @NativeType(value="bool")
    public static boolean SDL_AUDIO_ISSIGNED(@NativeType(value="SDL_AudioFormat") int x) {
        return (x & 0x8000) != 0;
    }

    @NativeType(value="bool")
    public static boolean SDL_AUDIO_ISINT(@NativeType(value="SDL_AudioFormat") int x) {
        return !SDLAudio.SDL_AUDIO_ISFLOAT(x);
    }

    @NativeType(value="bool")
    public static boolean SDL_AUDIO_ISUNSIGNED(@NativeType(value="SDL_AudioFormat") int x) {
        return !SDLAudio.SDL_AUDIO_ISSIGNED(x);
    }

    @NativeType(value="uint32_t")
    public static int SDL_AUDIO_FRAMESIZE(SDL_AudioSpec x) {
        return SDLAudio.SDL_AUDIO_BYTESIZE(x.format()) * x.channels();
    }

    public static int SDL_GetNumAudioDrivers() {
        long __functionAddress = Functions.GetNumAudioDrivers;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long nSDL_GetAudioDriver(int index) {
        long __functionAddress = Functions.GetAudioDriver;
        return JNI.invokeP((int)index, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetAudioDriver(int index) {
        long __result = SDLAudio.nSDL_GetAudioDriver(index);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static long nSDL_GetCurrentAudioDriver() {
        long __functionAddress = Functions.GetCurrentAudioDriver;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetCurrentAudioDriver() {
        long __result = SDLAudio.nSDL_GetCurrentAudioDriver();
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static long nSDL_GetAudioPlaybackDevices(long count) {
        long __functionAddress = Functions.GetAudioPlaybackDevices;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_AudioDeviceID *")
    public static @Nullable IntBuffer SDL_GetAudioPlaybackDevices() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLAudio.nSDL_GetAudioPlaybackDevices(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetAudioRecordingDevices(long count) {
        long __functionAddress = Functions.GetAudioRecordingDevices;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_AudioDeviceID *")
    public static @Nullable IntBuffer SDL_GetAudioRecordingDevices() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLAudio.nSDL_GetAudioRecordingDevices(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetAudioDeviceName(int devid) {
        long __functionAddress = Functions.GetAudioDeviceName;
        return JNI.invokeP((int)devid, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetAudioDeviceName(@NativeType(value="SDL_AudioDeviceID") int devid) {
        long __result = SDLAudio.nSDL_GetAudioDeviceName(devid);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static boolean nSDL_GetAudioDeviceFormat(int devid, long spec, long sample_frames) {
        long __functionAddress = Functions.GetAudioDeviceFormat;
        return JNI.invokePPZ((int)devid, (long)spec, (long)sample_frames, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetAudioDeviceFormat(@NativeType(value="SDL_AudioDeviceID") int devid, @NativeType(value="SDL_AudioSpec *") SDL_AudioSpec spec, @NativeType(value="int *") IntBuffer sample_frames) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)sample_frames, (int)1);
        }
        return SDLAudio.nSDL_GetAudioDeviceFormat(devid, spec.address(), MemoryUtil.memAddress((IntBuffer)sample_frames));
    }

    public static long nSDL_GetAudioDeviceChannelMap(int devid, long count) {
        long __functionAddress = Functions.GetAudioDeviceChannelMap;
        return JNI.invokePP((int)devid, (long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int *")
    public static @Nullable IntBuffer SDL_GetAudioDeviceChannelMap(@NativeType(value="SDL_AudioDeviceID") int devid) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLAudio.nSDL_GetAudioDeviceChannelMap(devid, MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nSDL_OpenAudioDevice(int devid, long spec) {
        long __functionAddress = Functions.OpenAudioDevice;
        return JNI.invokePI((int)devid, (long)spec, (long)__functionAddress);
    }

    @NativeType(value="SDL_AudioDeviceID")
    public static int SDL_OpenAudioDevice(@NativeType(value="SDL_AudioDeviceID") int devid, @NativeType(value="SDL_AudioSpec const *") @Nullable SDL_AudioSpec spec) {
        return SDLAudio.nSDL_OpenAudioDevice(devid, MemoryUtil.memAddressSafe((Pointer)spec));
    }

    @NativeType(value="bool")
    public static boolean SDL_IsAudioDevicePhysical(@NativeType(value="SDL_AudioDeviceID") int devid) {
        long __functionAddress = Functions.IsAudioDevicePhysical;
        return JNI.invokeZ((int)devid, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsAudioDevicePlayback(@NativeType(value="SDL_AudioDeviceID") int devid) {
        long __functionAddress = Functions.IsAudioDevicePlayback;
        return JNI.invokeZ((int)devid, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PauseAudioDevice(@NativeType(value="SDL_AudioDeviceID") int devid) {
        long __functionAddress = Functions.PauseAudioDevice;
        return JNI.invokeZ((int)devid, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ResumeAudioDevice(@NativeType(value="SDL_AudioDeviceID") int devid) {
        long __functionAddress = Functions.ResumeAudioDevice;
        return JNI.invokeZ((int)devid, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_AudioDevicePaused(@NativeType(value="SDL_AudioDeviceID") int devid) {
        long __functionAddress = Functions.AudioDevicePaused;
        return JNI.invokeZ((int)devid, (long)__functionAddress);
    }

    public static float SDL_GetAudioDeviceGain(@NativeType(value="SDL_AudioDeviceID") int devid) {
        long __functionAddress = Functions.GetAudioDeviceGain;
        return JNI.invokeF((int)devid, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioDeviceGain(@NativeType(value="SDL_AudioDeviceID") int devid, float gain) {
        long __functionAddress = Functions.SetAudioDeviceGain;
        return JNI.invokeZ((int)devid, (float)gain, (long)__functionAddress);
    }

    public static void SDL_CloseAudioDevice(@NativeType(value="SDL_AudioDeviceID") int devid) {
        long __functionAddress = Functions.CloseAudioDevice;
        JNI.invokeV((int)devid, (long)__functionAddress);
    }

    public static boolean nSDL_BindAudioStreams(int devid, long streams, int num_streams) {
        long __functionAddress = Functions.BindAudioStreams;
        return JNI.invokePZ((int)devid, (long)streams, (int)num_streams, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_BindAudioStreams(@NativeType(value="SDL_AudioDeviceID") int devid, @NativeType(value="SDL_AudioStream * const *") PointerBuffer streams) {
        return SDLAudio.nSDL_BindAudioStreams(devid, MemoryUtil.memAddress((CustomBuffer)streams), streams.remaining());
    }

    @NativeType(value="bool")
    public static boolean SDL_BindAudioStream(@NativeType(value="SDL_AudioDeviceID") int devid, @NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.BindAudioStream;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((int)devid, (long)stream, (long)__functionAddress);
    }

    public static void nSDL_UnbindAudioStreams(long streams, int num_streams) {
        long __functionAddress = Functions.UnbindAudioStreams;
        JNI.invokePV((long)streams, (int)num_streams, (long)__functionAddress);
    }

    public static void SDL_UnbindAudioStreams(@NativeType(value="SDL_AudioStream * const *") @Nullable PointerBuffer streams) {
        SDLAudio.nSDL_UnbindAudioStreams(MemoryUtil.memAddressSafe((Pointer)streams), Checks.remainingSafe((CustomBuffer)streams));
    }

    public static void SDL_UnbindAudioStream(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.UnbindAudioStream;
        JNI.invokePV((long)stream, (long)__functionAddress);
    }

    @NativeType(value="SDL_AudioDeviceID")
    public static int SDL_GetAudioStreamDevice(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.GetAudioStreamDevice;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePI((long)stream, (long)__functionAddress);
    }

    public static long nSDL_CreateAudioStream(long src_spec, long dst_spec) {
        long __functionAddress = Functions.CreateAudioStream;
        return JNI.invokePPP((long)src_spec, (long)dst_spec, (long)__functionAddress);
    }

    @NativeType(value="SDL_AudioStream *")
    public static long SDL_CreateAudioStream(@NativeType(value="SDL_AudioSpec const *") @Nullable SDL_AudioSpec src_spec, @NativeType(value="SDL_AudioSpec const *") @Nullable SDL_AudioSpec dst_spec) {
        return SDLAudio.nSDL_CreateAudioStream(MemoryUtil.memAddressSafe((Pointer)src_spec), MemoryUtil.memAddressSafe((Pointer)dst_spec));
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetAudioStreamProperties(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.GetAudioStreamProperties;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePI((long)stream, (long)__functionAddress);
    }

    public static boolean nSDL_GetAudioStreamFormat(long stream, long src_spec, long dst_spec) {
        long __functionAddress = Functions.GetAudioStreamFormat;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPPZ((long)stream, (long)src_spec, (long)dst_spec, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetAudioStreamFormat(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="SDL_AudioSpec *") @Nullable SDL_AudioSpec src_spec, @NativeType(value="SDL_AudioSpec *") @Nullable SDL_AudioSpec dst_spec) {
        return SDLAudio.nSDL_GetAudioStreamFormat(stream, MemoryUtil.memAddressSafe((Pointer)src_spec), MemoryUtil.memAddressSafe((Pointer)dst_spec));
    }

    public static boolean nSDL_SetAudioStreamFormat(long stream, long src_spec, long dst_spec) {
        long __functionAddress = Functions.SetAudioStreamFormat;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPPZ((long)stream, (long)src_spec, (long)dst_spec, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioStreamFormat(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="SDL_AudioSpec const *") @Nullable SDL_AudioSpec src_spec, @NativeType(value="SDL_AudioSpec const *") @Nullable SDL_AudioSpec dst_spec) {
        return SDLAudio.nSDL_SetAudioStreamFormat(stream, MemoryUtil.memAddressSafe((Pointer)src_spec), MemoryUtil.memAddressSafe((Pointer)dst_spec));
    }

    public static float SDL_GetAudioStreamFrequencyRatio(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.GetAudioStreamFrequencyRatio;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePF((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioStreamFrequencyRatio(@NativeType(value="SDL_AudioStream *") long stream, float ratio) {
        long __functionAddress = Functions.SetAudioStreamFrequencyRatio;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (float)ratio, (long)__functionAddress);
    }

    public static float SDL_GetAudioStreamGain(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.GetAudioStreamGain;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePF((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioStreamGain(@NativeType(value="SDL_AudioStream *") long stream, float gain) {
        long __functionAddress = Functions.SetAudioStreamGain;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (float)gain, (long)__functionAddress);
    }

    public static long nSDL_GetAudioStreamInputChannelMap(long stream, long count) {
        long __functionAddress = Functions.GetAudioStreamInputChannelMap;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPP((long)stream, (long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int *")
    public static @Nullable IntBuffer SDL_GetAudioStreamInputChannelMap(@NativeType(value="SDL_AudioStream *") long stream) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLAudio.nSDL_GetAudioStreamInputChannelMap(stream, MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetAudioStreamOutputChannelMap(long stream, long count) {
        long __functionAddress = Functions.GetAudioStreamOutputChannelMap;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPP((long)stream, (long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int *")
    public static @Nullable IntBuffer SDL_GetAudioStreamOutputChannelMap(@NativeType(value="SDL_AudioStream *") long stream) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLAudio.nSDL_GetAudioStreamOutputChannelMap(stream, MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetAudioStreamInputChannelMap(long stream, long chmap, int count) {
        long __functionAddress = Functions.SetAudioStreamInputChannelMap;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPZ((long)stream, (long)chmap, (int)count, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioStreamInputChannelMap(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="int const *") @Nullable IntBuffer chmap) {
        return SDLAudio.nSDL_SetAudioStreamInputChannelMap(stream, MemoryUtil.memAddressSafe((IntBuffer)chmap), Checks.remainingSafe((Buffer)chmap));
    }

    public static boolean nSDL_SetAudioStreamOutputChannelMap(long stream, long chmap, int count) {
        long __functionAddress = Functions.SetAudioStreamOutputChannelMap;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPZ((long)stream, (long)chmap, (int)count, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioStreamOutputChannelMap(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="int const *") @Nullable IntBuffer chmap) {
        return SDLAudio.nSDL_SetAudioStreamOutputChannelMap(stream, MemoryUtil.memAddressSafe((IntBuffer)chmap), Checks.remainingSafe((Buffer)chmap));
    }

    public static boolean nSDL_PutAudioStreamData(long stream, long buf, int len) {
        long __functionAddress = Functions.PutAudioStreamData;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPZ((long)stream, (long)buf, (int)len, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PutAudioStreamData(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="void const *") ByteBuffer buf) {
        return SDLAudio.nSDL_PutAudioStreamData(stream, MemoryUtil.memAddress((ByteBuffer)buf), buf.remaining());
    }

    public static boolean nSDL_PutAudioStreamDataNoCopy(long stream, long buf, int len, long callback, long userdata) {
        long __functionAddress = Functions.PutAudioStreamDataNoCopy;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPPPZ((long)stream, (long)buf, (int)len, (long)callback, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PutAudioStreamDataNoCopy(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="void const *") ByteBuffer buf, @NativeType(value="SDL_AudioStreamDataCompleteCallback") @Nullable SDL_AudioStreamDataCompleteCallbackI callback, @NativeType(value="void *") long userdata) {
        return SDLAudio.nSDL_PutAudioStreamDataNoCopy(stream, MemoryUtil.memAddress((ByteBuffer)buf), buf.remaining(), MemoryUtil.memAddressSafe((Pointer)callback), userdata);
    }

    public static boolean nSDL_PutAudioStreamPlanarData(long stream, long channel_buffers, int num_channels, int num_samples) {
        long __functionAddress = Functions.PutAudioStreamPlanarData;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPZ((long)stream, (long)channel_buffers, (int)num_channels, (int)num_samples, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PutAudioStreamPlanarData(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="void const * const *") PointerBuffer channel_buffers, int num_channels, int num_samples) {
        return SDLAudio.nSDL_PutAudioStreamPlanarData(stream, MemoryUtil.memAddress((CustomBuffer)channel_buffers), num_channels, num_samples);
    }

    public static int nSDL_GetAudioStreamData(long stream, long buf, int len) {
        long __functionAddress = Functions.GetAudioStreamData;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPI((long)stream, (long)buf, (int)len, (long)__functionAddress);
    }

    public static int SDL_GetAudioStreamData(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="void *") ByteBuffer buf) {
        return SDLAudio.nSDL_GetAudioStreamData(stream, MemoryUtil.memAddress((ByteBuffer)buf), buf.remaining());
    }

    public static int SDL_GetAudioStreamAvailable(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.GetAudioStreamAvailable;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePI((long)stream, (long)__functionAddress);
    }

    public static int SDL_GetAudioStreamQueued(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.GetAudioStreamQueued;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePI((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_FlushAudioStream(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.FlushAudioStream;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ClearAudioStream(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.ClearAudioStream;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_PauseAudioStreamDevice(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.PauseAudioStreamDevice;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ResumeAudioStreamDevice(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.ResumeAudioStreamDevice;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_AudioStreamDevicePaused(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.AudioStreamDevicePaused;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_LockAudioStream(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.LockAudioStream;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_UnlockAudioStream(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.UnlockAudioStream;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePZ((long)stream, (long)__functionAddress);
    }

    public static boolean nSDL_SetAudioStreamGetCallback(long stream, long callback, long userdata) {
        long __functionAddress = Functions.SetAudioStreamGetCallback;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPPZ((long)stream, (long)callback, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioStreamGetCallback(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="SDL_AudioStreamCallback") @Nullable SDL_AudioStreamCallbackI callback, @NativeType(value="void *") long userdata) {
        return SDLAudio.nSDL_SetAudioStreamGetCallback(stream, MemoryUtil.memAddressSafe((Pointer)callback), userdata);
    }

    public static boolean nSDL_SetAudioStreamPutCallback(long stream, long callback, long userdata) {
        long __functionAddress = Functions.SetAudioStreamPutCallback;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        return JNI.invokePPPZ((long)stream, (long)callback, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioStreamPutCallback(@NativeType(value="SDL_AudioStream *") long stream, @NativeType(value="SDL_AudioStreamCallback") @Nullable SDL_AudioStreamCallbackI callback, @NativeType(value="void *") long userdata) {
        return SDLAudio.nSDL_SetAudioStreamPutCallback(stream, MemoryUtil.memAddressSafe((Pointer)callback), userdata);
    }

    public static void SDL_DestroyAudioStream(@NativeType(value="SDL_AudioStream *") long stream) {
        long __functionAddress = Functions.DestroyAudioStream;
        if (Checks.CHECKS) {
            Checks.check((long)stream);
        }
        JNI.invokePV((long)stream, (long)__functionAddress);
    }

    public static long nSDL_OpenAudioDeviceStream(int devid, long spec, long callback, long userdata) {
        long __functionAddress = Functions.OpenAudioDeviceStream;
        return JNI.invokePPPP((int)devid, (long)spec, (long)callback, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="SDL_AudioStream *")
    public static long SDL_OpenAudioDeviceStream(@NativeType(value="SDL_AudioDeviceID") int devid, @NativeType(value="SDL_AudioSpec const *") @Nullable SDL_AudioSpec spec, @NativeType(value="SDL_AudioStreamCallback") @Nullable SDL_AudioStreamCallbackI callback, @NativeType(value="void *") long userdata) {
        return SDLAudio.nSDL_OpenAudioDeviceStream(devid, MemoryUtil.memAddressSafe((Pointer)spec), MemoryUtil.memAddressSafe((Pointer)callback), userdata);
    }

    public static boolean nSDL_SetAudioPostmixCallback(int devid, long callback, long userdata) {
        long __functionAddress = Functions.SetAudioPostmixCallback;
        return JNI.invokePPZ((int)devid, (long)callback, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetAudioPostmixCallback(@NativeType(value="SDL_AudioDeviceID") int devid, @NativeType(value="SDL_AudioPostmixCallback") @Nullable SDL_AudioPostmixCallbackI callback, @NativeType(value="void *") long userdata) {
        return SDLAudio.nSDL_SetAudioPostmixCallback(devid, MemoryUtil.memAddressSafe((Pointer)callback), userdata);
    }

    public static boolean nSDL_LoadWAV_IO(long src, boolean closeio, long spec, long audio_buf, long audio_len) {
        long __functionAddress = Functions.LoadWAV_IO;
        if (Checks.CHECKS) {
            Checks.check((long)src);
        }
        return JNI.invokePPPPZ((long)src, (boolean)closeio, (long)spec, (long)audio_buf, (long)audio_len, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_LoadWAV_IO(@NativeType(value="SDL_IOStream *") long src, @NativeType(value="bool") boolean closeio, @NativeType(value="SDL_AudioSpec *") SDL_AudioSpec spec, @NativeType(value="Uint8 **") PointerBuffer audio_buf, @NativeType(value="Uint32 *") IntBuffer audio_len) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)audio_buf, (int)1);
            Checks.check((Buffer)audio_len, (int)1);
        }
        return SDLAudio.nSDL_LoadWAV_IO(src, closeio, spec.address(), MemoryUtil.memAddress((CustomBuffer)audio_buf), MemoryUtil.memAddress((IntBuffer)audio_len));
    }

    public static boolean nSDL_LoadWAV(long path, long spec, long audio_buf, long audio_len) {
        long __functionAddress = Functions.LoadWAV;
        return JNI.invokePPPPZ((long)path, (long)spec, (long)audio_buf, (long)audio_len, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_LoadWAV(@NativeType(value="char const *") ByteBuffer path, @NativeType(value="SDL_AudioSpec *") SDL_AudioSpec spec, @NativeType(value="Uint8 **") PointerBuffer audio_buf, @NativeType(value="Uint32 *") IntBuffer audio_len) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
            Checks.check((CustomBuffer)audio_buf, (int)1);
            Checks.check((Buffer)audio_len, (int)1);
        }
        return SDLAudio.nSDL_LoadWAV(MemoryUtil.memAddress((ByteBuffer)path), spec.address(), MemoryUtil.memAddress((CustomBuffer)audio_buf), MemoryUtil.memAddress((IntBuffer)audio_len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_LoadWAV(@NativeType(value="char const *") CharSequence path, @NativeType(value="SDL_AudioSpec *") SDL_AudioSpec spec, @NativeType(value="Uint8 **") PointerBuffer audio_buf, @NativeType(value="Uint32 *") IntBuffer audio_len) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)audio_buf, (int)1);
            Checks.check((Buffer)audio_len, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLAudio.nSDL_LoadWAV(pathEncoded, spec.address(), MemoryUtil.memAddress((CustomBuffer)audio_buf), MemoryUtil.memAddress((IntBuffer)audio_len));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_MixAudio(long dst, long src, int format, int len, float volume) {
        long __functionAddress = Functions.MixAudio;
        return JNI.invokePPZ((long)dst, (long)src, (int)format, (int)len, (float)volume, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_MixAudio(@NativeType(value="Uint8 *") ByteBuffer dst, @NativeType(value="Uint8 const *") ByteBuffer src, @NativeType(value="SDL_AudioFormat") int format, float volume) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, (int)src.remaining());
        }
        return SDLAudio.nSDL_MixAudio(MemoryUtil.memAddress((ByteBuffer)dst), MemoryUtil.memAddress((ByteBuffer)src), format, src.remaining(), volume);
    }

    public static boolean nSDL_ConvertAudioSamples(long src_spec, long src_data, int src_len, long dst_spec, long dst_data, long dst_len) {
        long __functionAddress = Functions.ConvertAudioSamples;
        return JNI.invokePPPPPZ((long)src_spec, (long)src_data, (int)src_len, (long)dst_spec, (long)dst_data, (long)dst_len, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ConvertAudioSamples(@NativeType(value="SDL_AudioSpec const *") @Nullable SDL_AudioSpec src_spec, @NativeType(value="Uint8 const *") ByteBuffer src_data, @NativeType(value="SDL_AudioSpec const *") @Nullable SDL_AudioSpec dst_spec, @NativeType(value="Uint8 **") PointerBuffer dst_data, @NativeType(value="int *") IntBuffer dst_len) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)dst_data, (int)1);
            Checks.check((Buffer)dst_len, (int)1);
        }
        return SDLAudio.nSDL_ConvertAudioSamples(MemoryUtil.memAddressSafe((Pointer)src_spec), MemoryUtil.memAddress((ByteBuffer)src_data), src_data.remaining(), MemoryUtil.memAddressSafe((Pointer)dst_spec), MemoryUtil.memAddress((CustomBuffer)dst_data), MemoryUtil.memAddress((IntBuffer)dst_len));
    }

    public static long nSDL_GetAudioFormatName(int format) {
        long __functionAddress = Functions.GetAudioFormatName;
        return JNI.invokeP((int)format, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetAudioFormatName(@NativeType(value="SDL_AudioFormat") int format) {
        long __result = SDLAudio.nSDL_GetAudioFormatName(format);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static int SDL_GetSilenceValueForFormat(@NativeType(value="SDL_AudioFormat") int format) {
        long __functionAddress = Functions.GetSilenceValueForFormat;
        return JNI.invokeI((int)format, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetNumAudioDrivers = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumAudioDrivers");
        public static final long GetAudioDriver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioDriver");
        public static final long GetCurrentAudioDriver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCurrentAudioDriver");
        public static final long GetAudioPlaybackDevices = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioPlaybackDevices");
        public static final long GetAudioRecordingDevices = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioRecordingDevices");
        public static final long GetAudioDeviceName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioDeviceName");
        public static final long GetAudioDeviceFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioDeviceFormat");
        public static final long GetAudioDeviceChannelMap = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioDeviceChannelMap");
        public static final long OpenAudioDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_OpenAudioDevice");
        public static final long IsAudioDevicePhysical = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_IsAudioDevicePhysical");
        public static final long IsAudioDevicePlayback = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_IsAudioDevicePlayback");
        public static final long PauseAudioDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_PauseAudioDevice");
        public static final long ResumeAudioDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ResumeAudioDevice");
        public static final long AudioDevicePaused = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_AudioDevicePaused");
        public static final long GetAudioDeviceGain = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioDeviceGain");
        public static final long SetAudioDeviceGain = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioDeviceGain");
        public static final long CloseAudioDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CloseAudioDevice");
        public static final long BindAudioStreams = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_BindAudioStreams");
        public static final long BindAudioStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_BindAudioStream");
        public static final long UnbindAudioStreams = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UnbindAudioStreams");
        public static final long UnbindAudioStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UnbindAudioStream");
        public static final long GetAudioStreamDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamDevice");
        public static final long CreateAudioStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateAudioStream");
        public static final long GetAudioStreamProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamProperties");
        public static final long GetAudioStreamFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamFormat");
        public static final long SetAudioStreamFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioStreamFormat");
        public static final long GetAudioStreamFrequencyRatio = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamFrequencyRatio");
        public static final long SetAudioStreamFrequencyRatio = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioStreamFrequencyRatio");
        public static final long GetAudioStreamGain = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamGain");
        public static final long SetAudioStreamGain = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioStreamGain");
        public static final long GetAudioStreamInputChannelMap = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamInputChannelMap");
        public static final long GetAudioStreamOutputChannelMap = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamOutputChannelMap");
        public static final long SetAudioStreamInputChannelMap = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioStreamInputChannelMap");
        public static final long SetAudioStreamOutputChannelMap = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioStreamOutputChannelMap");
        public static final long PutAudioStreamData = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_PutAudioStreamData");
        public static final long PutAudioStreamDataNoCopy = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_PutAudioStreamDataNoCopy");
        public static final long PutAudioStreamPlanarData = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_PutAudioStreamPlanarData");
        public static final long GetAudioStreamData = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamData");
        public static final long GetAudioStreamAvailable = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamAvailable");
        public static final long GetAudioStreamQueued = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioStreamQueued");
        public static final long FlushAudioStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_FlushAudioStream");
        public static final long ClearAudioStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ClearAudioStream");
        public static final long PauseAudioStreamDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_PauseAudioStreamDevice");
        public static final long ResumeAudioStreamDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ResumeAudioStreamDevice");
        public static final long AudioStreamDevicePaused = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_AudioStreamDevicePaused");
        public static final long LockAudioStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LockAudioStream");
        public static final long UnlockAudioStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UnlockAudioStream");
        public static final long SetAudioStreamGetCallback = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioStreamGetCallback");
        public static final long SetAudioStreamPutCallback = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioStreamPutCallback");
        public static final long DestroyAudioStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyAudioStream");
        public static final long OpenAudioDeviceStream = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_OpenAudioDeviceStream");
        public static final long SetAudioPostmixCallback = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetAudioPostmixCallback");
        public static final long LoadWAV_IO = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LoadWAV_IO");
        public static final long LoadWAV = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LoadWAV");
        public static final long MixAudio = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_MixAudio");
        public static final long ConvertAudioSamples = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ConvertAudioSamples");
        public static final long GetAudioFormatName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetAudioFormatName");
        public static final long GetSilenceValueForFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSilenceValueForFormat");

        private Functions() {
        }
    }
}

