/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.system.Callback;
import org.lwjgl.system.MemoryUtil;

public abstract class GLDebugMessageCallback
extends Callback
implements GLDebugMessageCallbackI {
    public static GLDebugMessageCallback create(long functionPointer) {
        GLDebugMessageCallbackI instance = (GLDebugMessageCallbackI)Callback.get((long)functionPointer);
        return instance instanceof GLDebugMessageCallback ? (GLDebugMessageCallback)instance : new Container(functionPointer, instance);
    }

    public static @Nullable GLDebugMessageCallback createSafe(long functionPointer) {
        return functionPointer == 0L ? null : GLDebugMessageCallback.create(functionPointer);
    }

    public static GLDebugMessageCallback create(GLDebugMessageCallbackI instance) {
        return instance instanceof GLDebugMessageCallback ? (GLDebugMessageCallback)instance : new Container(instance.address(), instance);
    }

    protected GLDebugMessageCallback() {
        super(DESCRIPTOR);
    }

    GLDebugMessageCallback(long functionPointer) {
        super(functionPointer);
    }

    public static String getMessage(int length, long message) {
        return MemoryUtil.memUTF8((ByteBuffer)MemoryUtil.memByteBuffer((long)message, (int)length));
    }

    private static final class Container
    extends GLDebugMessageCallback {
        private final GLDebugMessageCallbackI delegate;

        Container(long functionPointer, GLDebugMessageCallbackI delegate) {
            super(functionPointer);
            this.delegate = delegate;
        }

        @Override
        public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
            this.delegate.invoke(source, type, id, severity, length, message, userParam);
        }
    }
}

