/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_vec2")
public class NkVec2
extends Struct<NkVec2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected NkVec2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkVec2 create(long address, @Nullable ByteBuffer container) {
        return new NkVec2(address, container);
    }

    public NkVec2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkVec2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return NkVec2.nx(this.address());
    }

    public float y() {
        return NkVec2.ny(this.address());
    }

    public NkVec2 x(float value) {
        NkVec2.nx(this.address(), value);
        return this;
    }

    public NkVec2 y(float value) {
        NkVec2.ny(this.address(), value);
        return this;
    }

    public NkVec2 set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public NkVec2 set(NkVec2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkVec2 malloc() {
        return new NkVec2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkVec2 calloc() {
        return new NkVec2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkVec2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkVec2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkVec2 create(long address) {
        return new NkVec2(address, null);
    }

    public static @Nullable NkVec2 createSafe(long address) {
        return address == 0L ? null : new NkVec2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkVec2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkVec2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkVec2 malloc(MemoryStack stack) {
        return new NkVec2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkVec2 calloc(MemoryStack stack) {
        return new NkVec2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)X));
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Y));
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)X), (float)value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)Y), (float)value);
    }

    static {
        Struct.Layout layout = NkVec2.__struct((Struct.Member[])new Struct.Member[]{NkVec2.__member((int)4), NkVec2.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkVec2, Buffer>
    implements NativeResource {
        private static final NkVec2 ELEMENT_FACTORY = NkVec2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkVec2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return NkVec2.nx(this.address());
        }

        public float y() {
            return NkVec2.ny(this.address());
        }

        public Buffer x(float value) {
            NkVec2.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            NkVec2.ny(this.address(), value);
            return this;
        }
    }
}

