/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkClipboard;
import org.lwjgl.nuklear.NkPluginFilter;
import org.lwjgl.nuklear.NkStr;
import org.lwjgl.nuklear.NkTextUndoState;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_text_edit")
public class NkTextEdit
extends Struct<NkTextEdit>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CLIP;
    public static final int STRING;
    public static final int FILTER;
    public static final int SCROLLBAR;
    public static final int CURSOR;
    public static final int SELECT_START;
    public static final int SELECT_END;
    public static final int MODE;
    public static final int CURSOR_AT_END_OF_LINE;
    public static final int INITIALIZED;
    public static final int HAS_PREFERRED_X;
    public static final int SINGLE_LINE;
    public static final int ACTIVE;
    public static final int PREFERRED_X;
    public static final int UNDO;

    protected NkTextEdit(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkTextEdit create(long address, @Nullable ByteBuffer container) {
        return new NkTextEdit(address, container);
    }

    public NkTextEdit(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkTextEdit.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_clipboard")
    public NkClipboard clip() {
        return NkTextEdit.nclip(this.address());
    }

    @NativeType(value="struct nk_str")
    public NkStr string() {
        return NkTextEdit.nstring(this.address());
    }

    @NativeType(value="nk_plugin_filter")
    public @Nullable NkPluginFilter filter() {
        return NkTextEdit.nfilter(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 scrollbar() {
        return NkTextEdit.nscrollbar(this.address());
    }

    public int cursor() {
        return NkTextEdit.ncursor(this.address());
    }

    public int select_start() {
        return NkTextEdit.nselect_start(this.address());
    }

    public int select_end() {
        return NkTextEdit.nselect_end(this.address());
    }

    @NativeType(value="unsigned char")
    public byte mode() {
        return NkTextEdit.nmode(this.address());
    }

    @NativeType(value="bool")
    public boolean cursor_at_end_of_line() {
        return NkTextEdit.ncursor_at_end_of_line(this.address());
    }

    @NativeType(value="bool")
    public boolean initialized() {
        return NkTextEdit.ninitialized(this.address());
    }

    @NativeType(value="bool")
    public boolean has_preferred_x() {
        return NkTextEdit.nhas_preferred_x(this.address());
    }

    @NativeType(value="bool")
    public boolean single_line() {
        return NkTextEdit.nsingle_line(this.address());
    }

    @NativeType(value="bool")
    public boolean active() {
        return NkTextEdit.nactive(this.address());
    }

    public float preferred_x() {
        return NkTextEdit.npreferred_x(this.address());
    }

    @NativeType(value="struct nk_text_undo_state")
    public NkTextUndoState undo() {
        return NkTextEdit.nundo(this.address());
    }

    public static NkTextEdit malloc() {
        return new NkTextEdit(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkTextEdit calloc() {
        return new NkTextEdit(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkTextEdit create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkTextEdit(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkTextEdit create(long address) {
        return new NkTextEdit(address, null);
    }

    public static @Nullable NkTextEdit createSafe(long address) {
        return address == 0L ? null : new NkTextEdit(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkTextEdit.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkTextEdit.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkTextEdit malloc(MemoryStack stack) {
        return new NkTextEdit(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkTextEdit calloc(MemoryStack stack) {
        return new NkTextEdit(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkClipboard nclip(long struct) {
        return NkClipboard.create(struct + (long)CLIP);
    }

    public static NkStr nstring(long struct) {
        return NkStr.create(struct + (long)STRING);
    }

    public static @Nullable NkPluginFilter nfilter(long struct) {
        return NkPluginFilter.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FILTER)));
    }

    public static NkVec2 nscrollbar(long struct) {
        return NkVec2.create(struct + (long)SCROLLBAR);
    }

    public static int ncursor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CURSOR));
    }

    public static int nselect_start(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SELECT_START));
    }

    public static int nselect_end(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SELECT_END));
    }

    public static byte nmode(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MODE));
    }

    public static boolean ncursor_at_end_of_line(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)CURSOR_AT_END_OF_LINE)) != 0;
    }

    public static boolean ninitialized(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)INITIALIZED)) != 0;
    }

    public static boolean nhas_preferred_x(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)HAS_PREFERRED_X)) != 0;
    }

    public static boolean nsingle_line(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SINGLE_LINE)) != 0;
    }

    public static boolean nactive(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ACTIVE)) != 0;
    }

    public static float npreferred_x(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)PREFERRED_X));
    }

    public static NkTextUndoState nundo(long struct) {
        return NkTextUndoState.create(struct + (long)UNDO);
    }

    static {
        Struct.Layout layout = NkTextEdit.__struct((Struct.Member[])new Struct.Member[]{NkTextEdit.__member((int)NkClipboard.SIZEOF, (int)NkClipboard.ALIGNOF), NkTextEdit.__member((int)NkStr.SIZEOF, (int)NkStr.ALIGNOF), NkTextEdit.__member((int)POINTER_SIZE), NkTextEdit.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkTextEdit.__member((int)4), NkTextEdit.__member((int)4), NkTextEdit.__member((int)4), NkTextEdit.__member((int)1), NkTextEdit.__member((int)1), NkTextEdit.__member((int)1), NkTextEdit.__member((int)1), NkTextEdit.__member((int)1), NkTextEdit.__member((int)1), NkTextEdit.__padding((int)1, (boolean)true), NkTextEdit.__member((int)4), NkTextEdit.__member((int)NkTextUndoState.SIZEOF, (int)NkTextUndoState.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CLIP = layout.offsetof(0);
        STRING = layout.offsetof(1);
        FILTER = layout.offsetof(2);
        SCROLLBAR = layout.offsetof(3);
        CURSOR = layout.offsetof(4);
        SELECT_START = layout.offsetof(5);
        SELECT_END = layout.offsetof(6);
        MODE = layout.offsetof(7);
        CURSOR_AT_END_OF_LINE = layout.offsetof(8);
        INITIALIZED = layout.offsetof(9);
        HAS_PREFERRED_X = layout.offsetof(10);
        SINGLE_LINE = layout.offsetof(11);
        ACTIVE = layout.offsetof(12);
        PREFERRED_X = layout.offsetof(14);
        UNDO = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<NkTextEdit, Buffer>
    implements NativeResource {
        private static final NkTextEdit ELEMENT_FACTORY = NkTextEdit.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkTextEdit getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_clipboard")
        public NkClipboard clip() {
            return NkTextEdit.nclip(this.address());
        }

        @NativeType(value="struct nk_str")
        public NkStr string() {
            return NkTextEdit.nstring(this.address());
        }

        @NativeType(value="nk_plugin_filter")
        public @Nullable NkPluginFilter filter() {
            return NkTextEdit.nfilter(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 scrollbar() {
            return NkTextEdit.nscrollbar(this.address());
        }

        public int cursor() {
            return NkTextEdit.ncursor(this.address());
        }

        public int select_start() {
            return NkTextEdit.nselect_start(this.address());
        }

        public int select_end() {
            return NkTextEdit.nselect_end(this.address());
        }

        @NativeType(value="unsigned char")
        public byte mode() {
            return NkTextEdit.nmode(this.address());
        }

        @NativeType(value="bool")
        public boolean cursor_at_end_of_line() {
            return NkTextEdit.ncursor_at_end_of_line(this.address());
        }

        @NativeType(value="bool")
        public boolean initialized() {
            return NkTextEdit.ninitialized(this.address());
        }

        @NativeType(value="bool")
        public boolean has_preferred_x() {
            return NkTextEdit.nhas_preferred_x(this.address());
        }

        @NativeType(value="bool")
        public boolean single_line() {
            return NkTextEdit.nsingle_line(this.address());
        }

        @NativeType(value="bool")
        public boolean active() {
            return NkTextEdit.nactive(this.address());
        }

        public float preferred_x() {
            return NkTextEdit.npreferred_x(this.address());
        }

        @NativeType(value="struct nk_text_undo_state")
        public NkTextUndoState undo() {
            return NkTextEdit.nundo(this.address());
        }
    }
}

