/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_str")
public class NkStr
extends Struct<NkStr>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int LEN;

    protected NkStr(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkStr create(long address, @Nullable ByteBuffer container) {
        return new NkStr(address, container);
    }

    public NkStr(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStr.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_buffer")
    public NkBuffer buffer() {
        return NkStr.nbuffer(this.address());
    }

    public int len() {
        return NkStr.nlen(this.address());
    }

    public static NkStr malloc() {
        return new NkStr(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkStr calloc() {
        return new NkStr(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkStr create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkStr(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkStr create(long address) {
        return new NkStr(address, null);
    }

    public static @Nullable NkStr createSafe(long address) {
        return address == 0L ? null : new NkStr(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkStr.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStr.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkStr malloc(MemoryStack stack) {
        return new NkStr(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStr calloc(MemoryStack stack) {
        return new NkStr(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkBuffer nbuffer(long struct) {
        return NkBuffer.create(struct + (long)BUFFER);
    }

    public static int nlen(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LEN));
    }

    static {
        Struct.Layout layout = NkStr.__struct((Struct.Member[])new Struct.Member[]{NkStr.__member((int)NkBuffer.SIZEOF, (int)NkBuffer.ALIGNOF), NkStr.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        LEN = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStr, Buffer>
    implements NativeResource {
        private static final NkStr ELEMENT_FACTORY = NkStr.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkStr getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_buffer")
        public NkBuffer buffer() {
            return NkStr.nbuffer(this.address());
        }

        public int len() {
            return NkStr.nlen(this.address());
        }
    }
}

