/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_image")
public class NkImage
extends Struct<NkImage>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int W;
    public static final int H;
    public static final int REGION;

    protected NkImage(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkImage create(long address, @Nullable ByteBuffer container) {
        return new NkImage(address, container);
    }

    public NkImage(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkImage.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle handle() {
        return NkImage.nhandle(this.address());
    }

    @NativeType(value="nk_ushort")
    public short w() {
        return NkImage.nw(this.address());
    }

    @NativeType(value="nk_ushort")
    public short h() {
        return NkImage.nh(this.address());
    }

    @NativeType(value="nk_ushort[4]")
    public ShortBuffer region() {
        return NkImage.nregion(this.address());
    }

    @NativeType(value="nk_ushort")
    public short region(int index) {
        return NkImage.nregion(this.address(), index);
    }

    public NkImage handle(@NativeType(value="nk_handle") NkHandle value) {
        NkImage.nhandle(this.address(), value);
        return this;
    }

    public NkImage handle(Consumer<NkHandle> consumer) {
        consumer.accept(this.handle());
        return this;
    }

    public NkImage w(@NativeType(value="nk_ushort") short value) {
        NkImage.nw(this.address(), value);
        return this;
    }

    public NkImage h(@NativeType(value="nk_ushort") short value) {
        NkImage.nh(this.address(), value);
        return this;
    }

    public NkImage region(@NativeType(value="nk_ushort[4]") ShortBuffer value) {
        NkImage.nregion(this.address(), value);
        return this;
    }

    public NkImage region(int index, @NativeType(value="nk_ushort") short value) {
        NkImage.nregion(this.address(), index, value);
        return this;
    }

    public NkImage set(NkHandle handle, short w, short h, ShortBuffer region) {
        this.handle(handle);
        this.w(w);
        this.h(h);
        this.region(region);
        return this;
    }

    public NkImage set(NkImage src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkImage malloc() {
        return new NkImage(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkImage calloc() {
        return new NkImage(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkImage create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkImage(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkImage create(long address) {
        return new NkImage(address, null);
    }

    public static @Nullable NkImage createSafe(long address) {
        return address == 0L ? null : new NkImage(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkImage.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkImage.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkImage malloc(MemoryStack stack) {
        return new NkImage(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkImage calloc(MemoryStack stack) {
        return new NkImage(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nhandle(long struct) {
        return NkHandle.create(struct + (long)HANDLE);
    }

    public static short nw(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)W));
    }

    public static short nh(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)H));
    }

    public static ShortBuffer nregion(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)REGION), (int)4);
    }

    public static short nregion(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)REGION + Checks.check((int)index, (int)4) * 2L));
    }

    public static void nhandle(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HANDLE), (long)NkHandle.SIZEOF);
    }

    public static void nw(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)W), (short)value);
    }

    public static void nh(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)H), (short)value);
    }

    public static void nregion(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)REGION), (long)(value.remaining() * 2));
    }

    public static void nregion(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)REGION + Checks.check((int)index, (int)4) * 2L), (short)value);
    }

    static {
        Struct.Layout layout = NkImage.__struct((Struct.Member[])new Struct.Member[]{NkImage.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkImage.__member((int)2), NkImage.__member((int)2), NkImage.__array((int)2, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        W = layout.offsetof(1);
        H = layout.offsetof(2);
        REGION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkImage, Buffer>
    implements NativeResource {
        private static final NkImage ELEMENT_FACTORY = NkImage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkImage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_handle")
        public NkHandle handle() {
            return NkImage.nhandle(this.address());
        }

        @NativeType(value="nk_ushort")
        public short w() {
            return NkImage.nw(this.address());
        }

        @NativeType(value="nk_ushort")
        public short h() {
            return NkImage.nh(this.address());
        }

        @NativeType(value="nk_ushort[4]")
        public ShortBuffer region() {
            return NkImage.nregion(this.address());
        }

        @NativeType(value="nk_ushort")
        public short region(int index) {
            return NkImage.nregion(this.address(), index);
        }

        public Buffer handle(@NativeType(value="nk_handle") NkHandle value) {
            NkImage.nhandle(this.address(), value);
            return this;
        }

        public Buffer handle(Consumer<NkHandle> consumer) {
            consumer.accept(this.handle());
            return this;
        }

        public Buffer w(@NativeType(value="nk_ushort") short value) {
            NkImage.nw(this.address(), value);
            return this;
        }

        public Buffer h(@NativeType(value="nk_ushort") short value) {
            NkImage.nh(this.address(), value);
            return this;
        }

        public Buffer region(@NativeType(value="nk_ushort[4]") ShortBuffer value) {
            NkImage.nregion(this.address(), value);
            return this;
        }

        public Buffer region(int index, @NativeType(value="nk_ushort") short value) {
            NkImage.nregion(this.address(), index, value);
            return this;
        }
    }
}

