/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union nk_handle")
public class NkHandle
extends Struct<NkHandle>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR;
    public static final int ID;

    protected NkHandle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkHandle create(long address, @Nullable ByteBuffer container) {
        return new NkHandle(address, container);
    }

    public NkHandle(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkHandle.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long ptr() {
        return NkHandle.nptr(this.address());
    }

    public int id() {
        return NkHandle.nid(this.address());
    }

    public NkHandle ptr(@NativeType(value="void *") long value) {
        NkHandle.nptr(this.address(), value);
        return this;
    }

    public NkHandle id(int value) {
        NkHandle.nid(this.address(), value);
        return this;
    }

    public NkHandle set(NkHandle src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkHandle malloc() {
        return new NkHandle(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkHandle calloc() {
        return new NkHandle(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkHandle create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkHandle(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkHandle create(long address) {
        return new NkHandle(address, null);
    }

    public static @Nullable NkHandle createSafe(long address) {
        return address == 0L ? null : new NkHandle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkHandle.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkHandle.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkHandle malloc(MemoryStack stack) {
        return new NkHandle(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkHandle calloc(MemoryStack stack) {
        return new NkHandle(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nptr(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PTR));
    }

    public static int nid(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ID));
    }

    public static void nptr(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTR), (long)value);
    }

    public static void nid(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ID), (int)value);
    }

    static {
        Struct.Layout layout = NkHandle.__union((Struct.Member[])new Struct.Member[]{NkHandle.__member((int)POINTER_SIZE), NkHandle.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR = layout.offsetof(0);
        ID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkHandle, Buffer>
    implements NativeResource {
        private static final NkHandle ELEMENT_FACTORY = NkHandle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkHandle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long ptr() {
            return NkHandle.nptr(this.address());
        }

        public int id() {
            return NkHandle.nid(this.address());
        }

        public Buffer ptr(@NativeType(value="void *") long value) {
            NkHandle.nptr(this.address(), value);
            return this;
        }

        public Buffer id(int value) {
            NkHandle.nid(this.address(), value);
            return this;
        }
    }
}

