/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_baked_font")
public class NkBakedFont
extends Struct<NkBakedFont>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEIGHT;
    public static final int ASCENT;
    public static final int DESCENT;
    public static final int GLYPH_OFFSET;
    public static final int GLYPH_COUNT;
    public static final int RANGES;

    protected NkBakedFont(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkBakedFont create(long address, @Nullable ByteBuffer container) {
        return new NkBakedFont(address, container);
    }

    public NkBakedFont(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkBakedFont.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float height() {
        return NkBakedFont.nheight(this.address());
    }

    public float ascent() {
        return NkBakedFont.nascent(this.address());
    }

    public float descent() {
        return NkBakedFont.ndescent(this.address());
    }

    @NativeType(value="nk_rune")
    public int glyph_offset() {
        return NkBakedFont.nglyph_offset(this.address());
    }

    @NativeType(value="nk_rune")
    public int glyph_count() {
        return NkBakedFont.nglyph_count(this.address());
    }

    @NativeType(value="nk_rune const *")
    public @Nullable IntBuffer ranges(int capacity) {
        return NkBakedFont.nranges(this.address(), capacity);
    }

    public NkBakedFont height(float value) {
        NkBakedFont.nheight(this.address(), value);
        return this;
    }

    public NkBakedFont ascent(float value) {
        NkBakedFont.nascent(this.address(), value);
        return this;
    }

    public NkBakedFont descent(float value) {
        NkBakedFont.ndescent(this.address(), value);
        return this;
    }

    public NkBakedFont glyph_offset(@NativeType(value="nk_rune") int value) {
        NkBakedFont.nglyph_offset(this.address(), value);
        return this;
    }

    public NkBakedFont glyph_count(@NativeType(value="nk_rune") int value) {
        NkBakedFont.nglyph_count(this.address(), value);
        return this;
    }

    public NkBakedFont ranges(@NativeType(value="nk_rune const *") @Nullable IntBuffer value) {
        NkBakedFont.nranges(this.address(), value);
        return this;
    }

    public NkBakedFont set(float height, float ascent, float descent, int glyph_offset, int glyph_count, @Nullable IntBuffer ranges) {
        this.height(height);
        this.ascent(ascent);
        this.descent(descent);
        this.glyph_offset(glyph_offset);
        this.glyph_count(glyph_count);
        this.ranges(ranges);
        return this;
    }

    public NkBakedFont set(NkBakedFont src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkBakedFont malloc() {
        return new NkBakedFont(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkBakedFont calloc() {
        return new NkBakedFont(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkBakedFont create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkBakedFont(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkBakedFont create(long address) {
        return new NkBakedFont(address, null);
    }

    public static @Nullable NkBakedFont createSafe(long address) {
        return address == 0L ? null : new NkBakedFont(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkBakedFont.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkBakedFont.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkBakedFont malloc(MemoryStack stack) {
        return new NkBakedFont(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkBakedFont calloc(MemoryStack stack) {
        return new NkBakedFont(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)HEIGHT));
    }

    public static float nascent(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)ASCENT));
    }

    public static float ndescent(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)DESCENT));
    }

    public static int nglyph_offset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GLYPH_OFFSET));
    }

    public static int nglyph_count(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GLYPH_COUNT));
    }

    public static @Nullable IntBuffer nranges(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)RANGES)), (int)capacity);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)HEIGHT), (float)value);
    }

    public static void nascent(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)ASCENT), (float)value);
    }

    public static void ndescent(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)DESCENT), (float)value);
    }

    public static void nglyph_offset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GLYPH_OFFSET), (int)value);
    }

    public static void nglyph_count(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GLYPH_COUNT), (int)value);
    }

    public static void nranges(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RANGES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
    }

    static {
        Struct.Layout layout = NkBakedFont.__struct((Struct.Member[])new Struct.Member[]{NkBakedFont.__member((int)4), NkBakedFont.__member((int)4), NkBakedFont.__member((int)4), NkBakedFont.__member((int)4), NkBakedFont.__member((int)4), NkBakedFont.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEIGHT = layout.offsetof(0);
        ASCENT = layout.offsetof(1);
        DESCENT = layout.offsetof(2);
        GLYPH_OFFSET = layout.offsetof(3);
        GLYPH_COUNT = layout.offsetof(4);
        RANGES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NkBakedFont, Buffer>
    implements NativeResource {
        private static final NkBakedFont ELEMENT_FACTORY = NkBakedFont.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkBakedFont getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float height() {
            return NkBakedFont.nheight(this.address());
        }

        public float ascent() {
            return NkBakedFont.nascent(this.address());
        }

        public float descent() {
            return NkBakedFont.ndescent(this.address());
        }

        @NativeType(value="nk_rune")
        public int glyph_offset() {
            return NkBakedFont.nglyph_offset(this.address());
        }

        @NativeType(value="nk_rune")
        public int glyph_count() {
            return NkBakedFont.nglyph_count(this.address());
        }

        @NativeType(value="nk_rune const *")
        public @Nullable IntBuffer ranges(int capacity) {
            return NkBakedFont.nranges(this.address(), capacity);
        }

        public Buffer height(float value) {
            NkBakedFont.nheight(this.address(), value);
            return this;
        }

        public Buffer ascent(float value) {
            NkBakedFont.nascent(this.address(), value);
            return this;
        }

        public Buffer descent(float value) {
            NkBakedFont.ndescent(this.address(), value);
            return this;
        }

        public Buffer glyph_offset(@NativeType(value="nk_rune") int value) {
            NkBakedFont.nglyph_offset(this.address(), value);
            return this;
        }

        public Buffer glyph_count(@NativeType(value="nk_rune") int value) {
            NkBakedFont.nglyph_count(this.address(), value);
            return this;
        }

        public Buffer ranges(@NativeType(value="nk_rune const *") @Nullable IntBuffer value) {
            NkBakedFont.nranges(this.address(), value);
            return this;
        }
    }
}

