/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkPluginAlloc;
import org.lwjgl.nuklear.NkPluginAllocI;
import org.lwjgl.nuklear.NkPluginFree;
import org.lwjgl.nuklear.NkPluginFreeI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_allocator")
public class NkAllocator
extends Struct<NkAllocator>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USERDATA;
    public static final int ALLOC;
    public static final int MFREE;

    protected NkAllocator(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkAllocator create(long address, @Nullable ByteBuffer container) {
        return new NkAllocator(address, container);
    }

    public NkAllocator(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkAllocator.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkAllocator.nuserdata(this.address());
    }

    @NativeType(value="nk_plugin_alloc")
    public @Nullable NkPluginAlloc alloc() {
        return NkAllocator.nalloc(this.address());
    }

    @NativeType(value="nk_plugin_free")
    public @Nullable NkPluginFree mfree() {
        return NkAllocator.nmfree(this.address());
    }

    public NkAllocator userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkAllocator.nuserdata(this.address(), value);
        return this;
    }

    public NkAllocator userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkAllocator alloc(@NativeType(value="nk_plugin_alloc") @Nullable NkPluginAllocI value) {
        NkAllocator.nalloc(this.address(), value);
        return this;
    }

    public NkAllocator mfree(@NativeType(value="nk_plugin_free") @Nullable NkPluginFreeI value) {
        NkAllocator.nmfree(this.address(), value);
        return this;
    }

    public NkAllocator set(NkHandle userdata, NkPluginAllocI alloc, NkPluginFreeI mfree) {
        this.userdata(userdata);
        this.alloc(alloc);
        this.mfree(mfree);
        return this;
    }

    public NkAllocator set(NkAllocator src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkAllocator malloc() {
        return new NkAllocator(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkAllocator calloc() {
        return new NkAllocator(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkAllocator create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkAllocator(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkAllocator create(long address) {
        return new NkAllocator(address, null);
    }

    public static @Nullable NkAllocator createSafe(long address) {
        return address == 0L ? null : new NkAllocator(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkAllocator.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkAllocator.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkAllocator malloc(MemoryStack stack) {
        return new NkAllocator(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkAllocator calloc(MemoryStack stack) {
        return new NkAllocator(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static @Nullable NkPluginAlloc nalloc(long struct) {
        return NkPluginAlloc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ALLOC)));
    }

    public static @Nullable NkPluginFree nmfree(long struct) {
        return NkPluginFree.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MFREE)));
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USERDATA), (long)NkHandle.SIZEOF);
    }

    public static void nalloc(long struct, @Nullable NkPluginAllocI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ALLOC), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmfree(long struct, @Nullable NkPluginFreeI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MFREE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkAllocator.__struct((Struct.Member[])new Struct.Member[]{NkAllocator.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkAllocator.__member((int)POINTER_SIZE), NkAllocator.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USERDATA = layout.offsetof(0);
        ALLOC = layout.offsetof(1);
        MFREE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkAllocator, Buffer>
    implements NativeResource {
        private static final NkAllocator ELEMENT_FACTORY = NkAllocator.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkAllocator getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkAllocator.nuserdata(this.address());
        }

        @NativeType(value="nk_plugin_alloc")
        public @Nullable NkPluginAlloc alloc() {
            return NkAllocator.nalloc(this.address());
        }

        @NativeType(value="nk_plugin_free")
        public @Nullable NkPluginFree mfree() {
            return NkAllocator.nmfree(this.address());
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkAllocator.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer alloc(@NativeType(value="nk_plugin_alloc") @Nullable NkPluginAllocI value) {
            NkAllocator.nalloc(this.address(), value);
            return this;
        }

        public Buffer mfree(@NativeType(value="nk_plugin_free") @Nullable NkPluginFreeI value) {
            NkAllocator.nmfree(this.address(), value);
            return this;
        }
    }
}

