/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class URLClassLoaderBase
extends URLClassLoader {
    private String name = "";

    public URLClassLoaderBase(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public URLClassLoaderBase(URL[] urls) {
        super(urls);
    }

    public URLClassLoaderBase(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public URLClassLoaderBase(String name, URL[] urls, ClassLoader parent) {
        this(urls, parent);
        this.name = name;
    }

    public URLClassLoaderBase(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(urls, parent, factory);
        this.name = name;
    }

    public static int implementationVersion() {
        return 8;
    }

    public String getClassLoaderName() {
        return this.name;
    }

    public static ClassLoader getPlatformClassLoader() {
        return null;
    }

    public Package getDefinedPackageUniversal(String name) {
        return this.getPackage(name);
    }

    public static Package getDefinedPackageUniversalOf(ClassLoader loader, String name) {
        return null;
    }

    public static byte[] readAllBytes(InputStream stream, byte[] readBuffer) throws IOException {
        int nRead;
        int availableBytes;
        if (readBuffer == null) {
            readBuffer = new byte[8192];
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream((availableBytes = stream.available()) < 32 ? 8192 : availableBytes);
        while ((nRead = stream.read(readBuffer, 0, readBuffer.length)) != -1) {
            outBuffer.write(readBuffer, 0, nRead);
        }
        return outBuffer.toByteArray();
    }

    public Package getAndVerifyPackage(String packageName, Manifest manifest, URL codeSourceURL) {
        Package pkg = this.getPackage(packageName);
        if (pkg != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(codeSourceURL)) {
                    System.err.println("Sealing violation in package " + packageName);
                }
            } else if (manifest != null && this.isSealed(packageName, manifest)) {
                System.err.println("Sealing violation in already loaded package " + packageName);
            }
        } else {
            return this.definePackage(packageName, manifest != null ? manifest : new Manifest(), codeSourceURL);
        }
        return pkg;
    }

    public boolean isSealed(String packageName, Manifest manifest) {
        String value;
        String value2;
        if (manifest == null) {
            return false;
        }
        String path = packageName.replace('.', '/') + '/';
        Attributes attributes = manifest.getAttributes(path);
        if (attributes != null && (value2 = attributes.getValue(Attributes.Name.SEALED)) != null) {
            return value2.equalsIgnoreCase("true");
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes != null && (value = mainAttributes.getValue(Attributes.Name.SEALED)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return false;
    }

    public static String getJavaVersion() {
        String ver = System.getProperty("java.runtime.version", "8.0.0");
        int plus = ver.indexOf(43);
        if (plus >= 0) {
            ver = ver.substring(0, plus);
        }
        return ver.replace('_', '.');
    }

    public static int getJavaMajorVersion() {
        String ver = System.getProperty("java.specification.version", "8");
        if (ver.startsWith("1.")) {
            ver = ver.substring(2);
        }
        try {
            return Integer.parseInt(ver);
        }
        catch (Exception e) {
            return 8;
        }
    }

    public static long getCurrentPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String combinedPidHostname = runtime.getName();
        String[] parts = combinedPidHostname.split("@", 2);
        return Integer.parseInt(parts[0]);
    }
}

