/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap;

import com.gtnewhorizons.retrofuturabootstrap.SharedConfig;
import com.gtnewhorizons.retrofuturabootstrap.URLClassLoaderWithUtilities;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.FastClassAccessor;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RfbSystemClassLoader
extends URLClassLoaderWithUtilities
implements ExtensibleClassLoader {
    public static Consumer<URL> addURLHook;
    private ClassLoader parent = this.getClass().getClassLoader();
    private static final ClassLoader platformLoader;
    private ExtensibleClassLoader childLoader = null;
    private final Map<String, WeakReference<Class<?>>> cachedClasses = new ConcurrentHashMap();
    private final Map<String, SoftReference<byte[]>> resourceCache = new ConcurrentHashMap<String, SoftReference<byte[]>>(1000);
    private Set<String> classLoaderExceptions = new HashSet<String>();
    public Set<String> childDelegations = new HashSet<String>();
    private static final Manifest EMPTY;
    private final ThreadLocal<HashSet<String>> isDelegatingToChild = new ThreadLocal();

    public RfbSystemClassLoader(String name, URL[] sources) {
        super(name, sources, RfbSystemClassLoader.getPlatformClassLoader());
        this.classLoaderExceptions.addAll(Arrays.asList("java.", "jdk.internal.", "sun.", "org.apache.logging.", "org.objectweb.asm.", "LZMA.", "org.slf4j.", "com.gtnewhorizons.retrofuturabootstrap."));
    }

    public RfbSystemClassLoader(ClassLoader parent) throws ReflectiveOperationException {
        this("System", RfbSystemClassLoader.getUrlClasspathEntries(parent));
        Thread.currentThread().setContextClassLoader(this);
    }

    public void setChildLoader(ExtensibleClassLoader ecl) {
        this.childLoader = ecl;
    }

    public ExtensibleClassLoader getChildLoader() {
        if (this.childLoader == null) {
            try {
                Class<?> lclClass = Class.forName("net.minecraft.launchwrapper.LaunchClassLoader", true, this);
                this.setChildLoader((ExtensibleClassLoader)lclClass.getConstructor(URL[].class).newInstance(new Object[]{this.getURLs()}));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.childLoader;
    }

    @NotNull
    public static URL[] getUrlClasspathEntries(ClassLoader appClassLoader) {
        if (appClassLoader instanceof URLClassLoader) {
            List<URL> appUrls = Arrays.asList(((URLClassLoader)appClassLoader).getURLs());
            Collections.reverse(appUrls);
            ArrayList<URL> urlSet = new ArrayList<URL>(appUrls);
            for (ClassLoader parent = appClassLoader.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof URLClassLoader)) continue;
                List<URL> parentUrls = Arrays.asList(((URLClassLoader)parent).getURLs());
                Collections.reverse(parentUrls);
                urlSet.addAll(parentUrls);
            }
            Collections.reverse(urlSet);
            return urlSet.toArray(new URL[0]);
        }
        return (URL[])Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(path -> {
            try {
                return new File((String)path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                System.err.printf("Could not parse %s into an URL%n%s%n", path, e.getMessage());
                e.printStackTrace(System.err);
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
    }

    @Override
    public Class<?> findCachedClass(String name) {
        WeakReference<Class<?>> cached = this.cachedClasses.get(name);
        if (cached != null) {
            return (Class)cached.get();
        }
        return null;
    }

    @Override
    @Nullable
    public FastClassAccessor findClassMetadata(@NotNull String name) {
        for (String exception : this.classLoaderExceptions) {
            if (!name.startsWith(exception)) continue;
            try {
                Class<?> loaded = this.parent.loadClass(name);
                return FastClassAccessor.ofLoaded(loaded);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        Class<?> cachedClass = this.findCachedClass(name);
        if (cachedClass != null) {
            return FastClassAccessor.ofLoaded(cachedClass);
        }
        try {
            byte[] classBytes = this.getClassBytes(name);
            if (classBytes != null) {
                return ClassHeaderMetadata.of(classBytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        CodeSource codeSource;
        Class cachedStrong;
        for (String string : this.classLoaderExceptions) {
            if (!name.startsWith(string)) continue;
            return this.parent.loadClass(name);
        }
        HashSet<String> isDelegatingToChild = this.isDelegatingToChild.get();
        if (isDelegatingToChild == null) {
            isDelegatingToChild = new HashSet();
            this.isDelegatingToChild.set(isDelegatingToChild);
        }
        if (isDelegatingToChild.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        for (String delegation : this.childDelegations) {
            if (!name.startsWith(delegation)) continue;
            boolean wasAdded = isDelegatingToChild.add(name);
            try {
                Class<?> clazz = ((URLClassLoader)((Object)this.getChildLoader())).loadClass(name);
                return clazz;
            }
            finally {
                if (wasAdded) {
                    isDelegatingToChild.remove(name);
                }
            }
        }
        WeakReference<Class<?>> weakReference = this.cachedClasses.get(name);
        if (weakReference != null && (cachedStrong = (Class)weakReference.get()) != null) {
            return cachedStrong;
        }
        int n = name.lastIndexOf(46);
        String packageName = n == -1 ? "" : name.substring(0, n);
        String classPath = name.replace('.', '/') + ".class";
        URLConnection connection = this.findCodeSourceConnectionFor(classPath);
        Package pkg = null;
        Manifest manifest = null;
        byte[] classBytes = null;
        if (!packageName.isEmpty()) {
            if (!name.startsWith("net.minecraft.") && connection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)connection;
                URL codeSourceUrl = jarConnection.getJarFileURL();
                CodeSigner[] codeSigners = null;
                try {
                    manifest = jarConnection.getManifest();
                    pkg = this.getAndVerifyPackage(packageName, manifest, codeSourceUrl);
                    classBytes = this.getClassBytes(name);
                    codeSigners = jarConnection.getJarEntry().getCodeSigners();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                codeSource = new CodeSource(codeSourceUrl, codeSigners);
            } else {
                codeSource = connection == null ? null : new CodeSource(connection.getURL(), (CodeSigner[])null);
            }
        } else {
            codeSource = null;
        }
        if (classBytes == null) {
            try {
                classBytes = this.getClassBytes(name);
            }
            catch (IOException jarConnection) {
                // empty catch block
            }
        }
        try {
            if (SharedConfig.cfgDumpLoadedClassesPerTransformer && classBytes != null) {
                SharedConfig.dumpClass(this.getClassLoaderName(), name + "_000_pretransform", classBytes);
            }
            classBytes = this.runRfbTransformers(SharedConfig.getRfbTransformers(), RfbClassTransformer.Context.SYSTEM, manifest, name, classBytes);
        }
        catch (Throwable t) {
            ClassNotFoundException err = new ClassNotFoundException("Exception caught while transforming class " + name, t);
            SharedConfig.logDebug("Transformer error", err);
            throw err;
        }
        if (classBytes == null) {
            throw new ClassNotFoundException(String.format("Class bytes are null for %s (%s, %s)", name, name, name));
        }
        if (!packageName.isEmpty() && pkg == null) {
            this.getAndVerifyPackage(packageName, null, null);
        }
        if (SharedConfig.cfgDumpLoadedClasses) {
            SharedConfig.dumpClass(this.getClassLoaderName(), name, classBytes);
        }
        Class<?> result = this.defineClass(name, classBytes, 0, classBytes.length, codeSource);
        this.cachedClasses.put(name, new WeakReference(result));
        return result;
    }

    @Override
    public Package getAndVerifyPackage(String packageName, Manifest manifest, URL codeSourceURL) {
        return super.getAndVerifyPackage(packageName, manifest, codeSourceURL);
    }

    @Override
    public boolean isSealed(String packageName, Manifest manifest) {
        return super.isSealed(packageName, manifest);
    }

    private URLConnection findCodeSourceConnectionFor(String name) {
        try {
            URL url = this.findResource(name);
            if (url == null) {
                return null;
            }
            return url.openConnection();
        }
        catch (Exception e) {
            SharedConfig.logDebug("Couldn't findCodeSourceConnectionFor " + name, e);
            return null;
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        if (addURLHook != null) {
            addURLHook.accept(url);
        }
    }

    @Override
    public void addSilentURL(@Nullable URL url) {
        super.addURL(url);
        if (addURLHook != null) {
            addURLHook.accept(url);
        }
    }

    public void appendToClassPathForInstrumentation(String path) {
        try {
            this.addURL(new File(path).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<URL> getSources() {
        return Arrays.asList(super.getURLs());
    }

    private byte[] readFully(InputStream stream) {
        try {
            return RfbSystemClassLoader.readAllBytes(stream, null);
        }
        catch (Exception e) {
            SharedConfig.logWarning("Could not read InputStream " + stream, e);
            return new byte[0];
        }
    }

    public void addClassLoaderExclusion(String toExclude) {
        this.classLoaderExceptions.add(toExclude);
    }

    public byte[] getClassBytes(String name) throws IOException {
        URL platformUrl;
        URLConnection conn;
        byte[] cachedStrong;
        SoftReference<byte[]> cached = this.resourceCache.get(name);
        if (cached != null && (cachedStrong = cached.get()) != null) {
            return (byte[])cachedStrong.clone();
        }
        String classPath = name.replace('.', '/') + ".class";
        URL resourceUrl = this.findResource(classPath);
        URLConnection uRLConnection = conn = resourceUrl == null ? null : resourceUrl.openConnection();
        if (conn == null && platformLoader != null && (platformUrl = platformLoader.getResource(classPath)) != null) {
            conn = platformUrl.openConnection();
        }
        if (conn == null) {
            return null;
        }
        InputStream is = conn.getInputStream();
        byte[] contents = this.readFully(is);
        RfbSystemClassLoader.closeSilently(is);
        if (contents == null) {
            return null;
        }
        this.resourceCache.put(name, new SoftReference<byte[]>(contents));
        return (byte[])contents.clone();
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public URLClassLoader asURLClassLoader() {
        return this;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        addURLHook = null;
        platformLoader = RfbSystemClassLoader.getPlatformClassLoader();
        EMPTY = new Manifest();
    }
}

